<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<style>
    div#myTable_wrapper {
        width: 100%;
    }

    table.dataTable th.dt-type-numeric,
    table.dataTable th.dt-type-date,
    table.dataTable td.dt-type-numeric,
    table.dataTable td.dt-type-date {
        text-align: left;
    }

        
    .row {
    display: -ms-flexbox;
    display: flex;
    -ms-flex-wrap: wrap;
    flex-wrap: wrap;
    margin-right: -7.5px;
    margin-left: -7.5px;
    flex-direction: column;
    justify-content: space-between;
}
 
     .zoom-wrapper {
        position: relative;
        width: 60px;
        height: 60px;
        overflow: visible;
        /* allow zoom outside */
        z-index: 1;
    }

    /* Base image style */
    .zoom-img {
        width: 60px;
        height: 60px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-radius: 2px;
        z-index: 1;
        position: relative;
    }

    /* Zoom effect */
    .zoom-wrapper:hover .zoom-img {
        transform: scale(3);
        /* zoom 3x outward */
        position: absolute;
        top: -60px;
        /* shift up */
        left: 60px;
        /* shift left */
        z-index: 999;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        border: 2px solid #fff;
        background: #fff;
        border-radius: 6px;
    }

            .zoom-wrapper {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .zoom-wrapper img {
            width: 100px;
            height: 70px;
            object-fit: cover;
            transition: transform 0.3s ease;
            cursor: zoom-in;
        }

        .zoom-wrapper img:hover {
            transform: scale(2); /* Zoom level */
            z-index: 999;
            position: relative;
        }
</style>

<div class="content-wrapper" style="background-color:#fff;">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mt-2">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success"> <?php echo $this->session->flashdata('success'); ?> </div>
                    <?php elseif ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger"> <?php echo $this->session->flashdata('error'); ?> </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 text-right">
                    <!-- <a href="<?php echo base_url('admin/add-sleeve/' . $fabric_id); ?>" class="btn btn-primary mb-2">Add New sleeves</a> -->
                    <a href="<?php echo base_url('admin/add-sleeve'); ?>" class="btn btn-primary mb-2">Add New sleeves</a>
                </div>
            </div>
            <!-- <?php //print_r($sleeves);
                    ?> -->
            <div class="row">
                <?php if (!empty($sleeves)): ?>
                    <table class="table table-bordered table-striped" id="myTable">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>Sleeves Image / Title</th>
                                <!-- <th>sleeves Title</th> -->
                                <th>Fabric Name</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $serial_number = $page_no + 1; ?>
                            <?php foreach ($sleeves as $s): ?>
                                <tr>
                                    <td><?php echo $serial_number++; ?></td>
                                    <!-- Add this CSS in your <head> or sleevessheet -->

                                    <!-- Your image block -->
                                    <td>
                                        <div style="display: flex; align-items: center;">
                                            <div class="zoom-wrapper" style="margin-right: 10px;">
                                                <?php if (!empty($s['sleeves_image'])): ?>
                                                    <img src="<?php echo base_url('uploads/fabric/' . $s['sleeves_image']); ?>" width="50" height="50" style="object-fit: cover;" alt="Sleeve Image">
                                                <?php else: ?>
                                                    <div style="width: 50px; height: 50px; background: #f0f0f0; display: flex; align-items: center; justify-content: center; font-size: 10px; color: #888;">
                                                        No Image
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <span><?php echo $s['sleeves_title']; ?></span>
                                        </div>

                                    </td>


                                    <td><?php echo $s['design_no']; ?></td>

                                    <td><?php echo date('d-m-Y', strtotime($s['created_at'])); ?></td>

                                    <td sleeves="color: <?php echo $s['status'] == 'Active' ? 'green' : 'red'; ?>;">
                                        <button type="button" title="Change status" onclick="beforeChangeStatus(<?php echo $s['id']; ?>);" class="btn <?php echo $s['status'] == 'InActive' ? 'btn-outline-danger' : 'btn-outline-success'; ?>">
                                            <i class="fas <?php echo $s['status'] == 'InActive' ? 'fa-toggle-off' : 'fa-toggle-on'; ?>"></i>
                                        </button>
                                    </td>

                                    <td>
                                        <a href="<?php echo base_url('admin/edit-sleeve/' . $s['id']); ?>" class="btn btn-outline-secondary" title="Edit Records">
                                            <i class="fas fa-edit"></i>
                                        </a>

                                        <!-- <button type="button" class="btn btn-outline-primary" data-toggle="modal" data-target="#viewModal_<?php echo $s['id']; ?>" title="view Records">
                                            <i class="fas fa-eye"></i>
                                        </button> -->

                                        <!-- <a href="<?php echo base_url('admin/edit-sleeves/' . $s['id']); ?>" class="btn btn-outline-secondary" title="Add sleeves">
                                            <i class="fas fa-plus"></i>
                                        </a> -->


                                    </td>


                                </tr>

                                <!-- View Modal -->
                                <!-- <div class="modal fade" id="viewModal_<?php echo $f['sleeves_id']; ?>" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel_<?php echo $f['sleeves_id']; ?>" aria-hidden="true">
                                    <div class="modal-dialog modal-lg" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">sleeves Details</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="row mb-2">
                                                    <div class="col-md-4"><strong>Design No:</strong></div>
                                                    <div class="col-md-8"><?php echo $f['design_no']; ?></div>
                                                </div>
                                                <div class="row mb-2">
                                                    <div class="col-md-4"><strong>Blend:</strong></div>
                                                    <div class="col-md-8"><?php echo $f['blend']; ?></div>
                                                </div>
                                                <div class="row mb-2">
                                                    <div class="col-md-4"><strong>Prices:</strong></div>
                                                    <div class="col-md-8">
                                                        INR: ₹<?php echo $f['price_inr']; ?><br>
                                                        USD: $<?php echo $f['price_usd']; ?><br>
                                                        GBP: £<?php echo $f['price_gbp']; ?><br>
                                                        EUR: €<?php echo $f['price_euro']; ?>
                                                    </div>
                                                </div>
                                                <div class="row mb-2">
                                                    <div class="col-md-4"><strong>Washcare:</strong></div>
                                                    <div class="col-md-8"><?php echo $f['washcare']; ?></div>
                                                </div>
                                                <div class="row mb-2">
                                                    <div class="col-md-4"><strong>Image:</strong></div>
                                                    <div class="col-md-8">
                                                        <?php if (!empty($f['sleeves_image'])): ?>
                                                            <img src="<?php echo base_url('uploads/sleeves/' . $f['sleeves_image']); ?>" width="100">
                                                        <?php else: ?>
                                                            No Image
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div> -->
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="col-md-12 text-center">
                        <p>No records found</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
</div>

<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    function beforeChangeStatus(id) {
        swal({
            title: "Are you sure?",
            text: "You want to change the status.",
            icon: "warning",
            buttons: {
                cancel: 'Cancel',
                ok: {
                    text: "Yes",
                    value: true,
                },
            },
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: "<?php echo base_url('admin/sleeve-status-update'); ?>",
                    type: "POST",
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function(response) {
                        location.reload();
                    },
                    error: function() {
                        alert('Error updating status.');
                    }
                });
            }
        });
    }
</script>

<script>
    $(document).ready(function () {
        $('#myTable').DataTable({
            pageLength: 10,
            lengthChange: true,
            ordering: true,
            autoWidth: false
        });
    });
</script>