<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<style>
    div#myTable_wrapper {
        width: 100%;
    }

    table.dataTable th.dt-type-numeric,
    table.dataTable th.dt-type-date,
    table.dataTable td.dt-type-numeric,
    table.dataTable td.dt-type-date {
        text-align: left;
    }

    .row {
        display: -ms-flexbox;
        display: flex;
        -ms-flex-wrap: wrap;
        flex-wrap: wrap;
        margin-right: -7.5px;
        margin-left: -7.5px;
        flex-direction: column;
        justify-content: space-between;
    }

    /* Container that allows image to overflow on hover */
    .zoom-wrapper {
        position: relative;
        width: 60px;
        height: 60px;
        overflow: visible;
        /* allow zoom outside */
        z-index: 1;
    }

    /* Base image style */
    .zoom-img {
        width: 60px;
        height: 60px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-radius: 2px;
        z-index: 1;
        position: relative;
    }

    /* Zoom effect */
    .zoom-wrapper:hover .zoom-img {
        transform: scale(3);
        /* zoom 3x outward */
        position: absolute;
        top: -60px;
        /* shift up */
        left: 60px;
        /* shift left */
        z-index: 999;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        border: 2px solid #fff;
        background: #fff;
        border-radius: 6px;
    }

    .zoom-wrapper {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .zoom-wrapper img {
        width: 100px;
        height: 70px;
        object-fit: cover;
        transition: transform 0.3s ease;
        cursor: zoom-in;
    }

    .zoom-wrapper img:hover {
        transform: scale(2);
        /* Zoom level */
        z-index: 999;
        position: relative;
    }


    /* ✅ Custom button colors */
    .swal-button--complete {
        background-color: green !important;
        color: #fff !important;
    }

    .swal-button--cancelled {
        background-color: red !important;
        color: #fff !important;
    }

    .swal-button--dispatched {
        background-color: skyblue !important;
        color: #fff !important;
    }

    .swal-button--cancel {
        background-color: #777 !important;
        color: #fff !important;
    }
</style>

<div class="content-wrapper" style="background-color:#fff;">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mt-2">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success"> <?php echo $this->session->flashdata('success'); ?> </div>
                    <?php elseif ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger"> <?php echo $this->session->flashdata('error'); ?> </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <?php if (!empty($order)): ?>
                    <table class="table table-bordered table-striped" id="myTable">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>Order Date</th>
                                <th>Order Id</th>
                                <th>User Mobile</th>
                                <!-- <th>Order Price</th> -->
                                <th>Payment Mode</th>
                                <!-- <th>Payment Status</th> -->
                                <th>Order Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $serial_number = $page_no + 1; ?>
                            <?php foreach ($order as $o): ?>
                                <tr>
                                    <td><?php echo $serial_number++; ?></td>
                                    <td><?php echo date('j F Y', strtotime($o['created_date'])); ?></td>
                                    <td><?php echo $o['order_id']; ?></td>
                                    <td><?php echo $o['mobile']; ?></td>
                                    <!-- <td><?php echo 9999; ?></td> -->
                                    <td><?php echo "COD"; ?></td>
                                    <!-- <td><?php //echo $o['payment_status']; 
                                                ?></td> -->
                                    <td>
                                        <?php
                                        $statusColors = [
                                            'Pending'    => 'red',
                                            'Cancelled'  => 'black',
                                            'Dispatched' => 'blue',
                                            'In-Transit' => 'orange',
                                            'Completed'  => 'green'
                                        ];
                                        $status = $o['order_status'];
                                        $color = isset($statusColors[$status]) ? $statusColors[$status] : 'red';
                                        ?>
                                        <span style="cursor: pointer; color: <?= $color; ?>;"
                                            onclick="beforeChangeStatus(<?= $o['id']; ?>, '<?= $status; ?>')">
                                            <?= $status; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <a href="<?php echo base_url('admin/order-details/' . $o['order_id']); ?>" class="btn btn-outline-primary" title="View Records">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                <?php else: ?>
                    <div class="col-md-12 text-center">
                        <p>No records found</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
</div>

<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    function beforeChangeStatus(id) {
        swal({
            title: "Order Status",
            text: "Are you sure you want to change the status?",
            icon: "warning",
            buttons: {
                cancel: {
                    text: "Cancel",
                    visible: true,
                },

                cancelled: {
                    text: "Cancelled",
                    value: "Cancelled",
                    className: "swal-button--red",
                },
                dispatched: {
                    text: "Dispatched",
                    value: "Dispatched",
                    className: "swal-button--blue",
                },
            },
            dangerMode: true,
        }).then((status) => {
            if (status) {
                $.ajax({
                    url: "<?php echo base_url('admin/pending-order-status-update'); ?>",
                    type: "POST",
                    data: {
                        id: id,
                        status: status
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.status === 'success') {
                            location.reload();
                        } else {
                            alert(response.message);
                        }
                    },
                    error: function() {
                        alert('Error updating status.');
                    }
                });
            }
        });
    }
</script>

<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            pageLength: 10,
            lengthChange: true,
            ordering: true,
            autoWidth: false
        });
    });
</script>