<!DOCTYPE html>
<html lang="en">

<style>
    body {
        background: #f8f9fa;
    }

    .order-summary,
    .order-details,
    .amount-details {
        background: #fff;
        border-radius: 6px;
        padding: 20px;
        margin-bottom: 20px;
        box-shadow: 0px 1px 4px rgba(0, 0, 0, 0.1);
    }

    .order-section-title {
        font-weight: bold;
        margin-bottom: 15px;
        font-size: 18px;
        border-bottom: 1px solid #ddd;
        padding-bottom: 8px;
    }

    .table th,
    .table td {
        vertical-align: middle !important;
    }

    .order_de {
        margin-block-end: 0;
        margin-block-start: 3.85rem;
        margin-inline-start: 15rem;
        transition: all 50ms ease;
        padding: 0 .5em;
    }

    .alert-info {
        color: #0c5460;
        background-color: #d1ecf1;
        border-color: #bee5eb;
    }
</style>
<style>
    .card.height-300 {
        height: 308px;
    }

    .suit-preview,
    .suit-preview-back {
        position: relative;
        width: 150px;
        /* margin: auto; */
        /* margin-top: 55px; */
        top: -90px;
    }

    .suit-preview img,
    .suit-preview-back img {
        position: absolute;
        top: 20px;
        left: 30px;
        width: 130%;
    }

    .pant-preview {
        position: relative;
        margin-top: 90px !important;
    }

    .pant-preview {
        width: 100%;
        left: 15px;
    }

    .pant-preview img {
        width: 100%;
        max-width: 220px;
    }

    .pant-preview #main4 {
        margin-top: 45px;
    }

    .pant-preview #main5,
    .pant-preview #main6 {
        position: absolute;
        z-index: 99;
        left: 0px;
        top: 45px;
    }
</style>

<?php $value = $orderDetails; ?>

<section class="order_de py-3">
    <div class="container">
        <div class="row justify-content-center align-items-center">
            <div class="col-lg-8 d-flex justify-content-between align-items-center">
                <!-- Back Button -->
                <a href="<?php echo base_url() . 'admin/dispatched-order'; ?>" class="btn btn-secondary">
                    &larr; Back
                </a>

                <!-- Order ID -->
                <div class="alert-info mb-0 py-2 px-3 text-center flex-grow-1 mx-3" role="alert">
                    <strong>Order ID:</strong> <?php echo htmlspecialchars($value['order_id']); ?>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="order_de">
    <div class="container-fluid mt-4">
        <div class="row">
            <!-- Left Section -->
            <div class="col-md-12">
                <div class="order-summary">
                    <h5 class="order-section-title">Order Summary</h5>
                    <div class="row">
                        <div class="col-md-6"><strong>Order Date:</strong> <?php echo date('d M Y', strtotime($value['created_date'])); ?></div>
                        <div class="col-md-6"><strong>Total Amount:</strong> ₹999</div>
                        <div class="col-md-6"><strong>Payment Method:</strong> Cash On Delivered</div>
                        <div class="col-md-6"><strong>Payment Status:</strong> <?php echo $value['payment_status']; ?></div>
                        <div class="col-md-6"><strong>Order Status:</strong> <?php echo $value['order_status']; ?></div>

                        <!-- <div class="col-md-6" style="display-none;"><strong>Shipment Type:</strong> Shiprocket</div> -->
                    </div>
                </div>


            </div>
            <div class="col-md-6">
                <div class="order-details">
                    <h5 class="order-section-title">Order Details</h5>
                    <!-- <p><strong>Total Item:</strong> 1 Items</p> -->
                    <p><strong>Delivery Date:</strong> Jul 28, 2025</p>

                    <?php
                    // Decode the JSON stored in order_address_details
                    $orderDetails = json_decode($value['order_address_details'], true);

                    if (!empty($orderDetails)) {
                        echo '<p><strong>Customer Name:</strong> ' . htmlspecialchars($orderDetails['customer_name'] ?? '') . '</p>';
                        echo '<p><strong>Mobile:</strong> ' . htmlspecialchars($orderDetails['customer_mobile'] ?? '') . '</p>';
                        echo '<p><strong>Email:</strong> ' . htmlspecialchars($orderDetails['customer_email'] ?? '') . '</p>';
                        echo '<p><strong>Address:</strong> ' . htmlspecialchars($orderDetails['customer_address'] ?? '') . '</p>';
                        echo '<p><strong>Pincode:</strong> ' . htmlspecialchars($orderDetails['customer_pincode'] ?? '') . '</p>';
                    }
                    ?>
                </div>
            </div>


            <!-- Right Section -->
            <div class="col-md-6">
                <div class="amount-details">
                    <h5 class="order-section-title">Amount Details</h5>
                    <p><strong>Sub Total:</strong> ₹640</p>
                    <p><strong>Delivery:</strong> ₹55</p>
                    <p><strong>Discount:</strong> -</p>
                    <p><strong>Total:</strong> ₹695</p>
                </div>
            </div>



        </div>

        <!-- Product Table -->
        <div class="order-details">
            <h5 class="order-section-title">Suits</h5>
            <?php
            $cart = json_decode($value['order_details']);
            foreach ($cart as $key => $c): ?>
                <div class="card mb-4 border-0 position-relative height-300">
                    <div class="row g-0 align-items-center">
                        <div class="col-md-4 text-center position-relative">
                            <div class="position-absolute">
                                <?php
                                // Example: image path based on fabric name (fallback to default)
                                $imagePath = base_url() . 'assets/front/img/detail/man1-2.png';
                                ?>
                                <!-- <img src=" <?php echo $imagePath; ?>" class="img-fluid rounded-start w-75" alt="<?php echo ucfirst($c->fabric); ?>"> -->
                                <div class="gen-new suit-preview position-absolute">
                                    <img id="collar" src="<?php echo S3_BASE_URL; ?><?php echo S3_TYPE ?>/fabric/<?php echo $c->fabric; ?>/interior/collar.png" alt="Collar Layer">

                                    <img class="standard" id="front_interior_top" src="<?php echo S3_BASE_URL; ?><?php echo S3_TYPE ?>/lining/<?php echo $c->internal_lining ?>%2B<?php echo $c->lining ?>%2Btop_image.png" alt="Lining Layer">
                                    <img class="standard" id="front_interior_bottom" src="<?php echo S3_BASE_URL; ?><?php echo S3_TYPE ?>/lining/<?php echo $c->internal_lining ?>%2B<?php echo $c->lining ?>%2Bbottom_image.png" alt="Lining Layer">

                                    <img id="main3" src="<?php echo S3_BASE_URL; ?><?php echo S3_TYPE ?>/fabric/<?php echo $c->fabric; ?>/front/sleeves.png" alt="Sleeves Layer">
                                    <img id="main2" src="<?php echo S3_BASE_URL; ?><?php echo S3_TYPE ?>/fabric/<?php echo $c->fabric; ?>/front/bottom.png" alt="Bottom Layer">
                                    <img id="main1" src="<?php echo S3_BASE_URL; ?><?php echo S3_TYPE ?>/fabric/<?php echo $c->fabric; ?>/front/<?php echo $c->neck; ?>%2B<?php echo $c->lapel_width; ?>%2B<?php echo $c->lapel; ?>.png" alt="Main Layer">
                                </div>
                                <div class="pant-preview mt-5 text-start">
                                    <img id="main4" src="<?php echo S3_BASE_URL; ?><?php echo S3_TYPE ?>/fabric/<?php echo $c->fabric; ?>/pant/<?php echo $c->style; ?>%2Bfolded_pant.png" alt="Pant Preview">
                                    <img id="main5" src="<?php echo S3_BASE_URL; ?><?php echo S3_TYPE ?>/fabric/<?php echo $c->fabric; ?>/pant/<?php echo $c->style; ?>%2Bpocket.png" alt="Pant Preview">
                                    <img id="main6" src="<?php echo S3_BASE_URL; ?><?php echo S3_TYPE ?>/fabric/<?php echo $c->fabric; ?>/pant/<?php echo $c->style; ?>%2Bbutton.png" alt="Pant Preview">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="card-body">
                                <h5 class="card-title mb-1">Custom Suit</h5>
                                <p class="card-text mb-0">
                                    <small class="text-body-secondary">
                                        <?php echo ucfirst(str_replace('-', ' ', $c->fabric)); ?>,
                                        <?php echo isset($c->style) ? ucfirst($c->style) : ''; ?>
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        ₹<?php echo isset($c->price) ? $c->price : '29950'; ?>
                                    </small>
                                </p>

                                <a href="<?php echo base_url('cart?delete=' . $key); ?>" class="button-1 me-3 d-none">Delete<span></span></a>
                                <!-- <a class="wishlist" href="#"><i class="fa-heart fa"></i></a> -->
                            </div>
                        </div>

                    </div>
                </div>
            <?php endforeach; ?>


        </div>
    </div>
</section>

</body>

</html>