<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Richman Clothing | Admin</title>
    <link rel="icon" type="image/x-icon" href="<?php echo base_url() . 'assets/front/img/new/LLL.png'; ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

    <style>
        body {
            background: url('<?php echo base_url("assets/front/img/new/bg.jpg"); ?>') no-repeat center center fixed;
            background-size: cover;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-box {
            width: 400px;
            background-color: #16000042;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        .login-box img {
            width: 40%;
            margin-bottom: 20px;
        }

        .form-control {
            border-radius: 8px;
        }

        .btn-primary {
            background: #c1813b;
            border: none;
            border-radius: 8px;
            padding: 10px;
            font-size: 16px;
        }

        .btn-custom {
    background-color: #001242;
    color: white;
    border: none;
}

.btn-custom:hover {
    background-color: #001242;
    color: white;
}


        .logo {
            padding: 7px;
            border-radius: 12px;
        }
    </style>

</head>

<body>
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="login-box">

        <div class="logo">
            <img src="<?php echo base_url() . 'assets/front/img/new/Logo.png'; ?>" alt="Logo">
        </div>

        <!-- <h3>Login</h3> -->
        <h4 class="mb-3 text-white">Sign in to your account</h4>
        <?php if ($this->session->flashdata('admin_login_error')) { ?>
            <div class="alert alert-danger" role="alert">
                <?php echo $this->session->flashdata('admin_login_error'); ?>
            </div>
        <?php } ?>
        <form action="<?php echo base_url('admin/login'); ?>" method="POST">
            <div class="mb-3">
                <input type="email" name="email" class="form-control" placeholder="Email" required>
            </div>
            <div class="mb-3">
                <input type="password" name="password" class="form-control" placeholder="Password" required>
            </div>
            <button type="submit" class="btn btn-custom w-100">Sign In</button>
        </form>
    </div>
            </div>
            <div class="col-md-6"></div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>