<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<style>
    div#myTable_wrapper {
        width: 100%;
    }

    table.dataTable th.dt-type-numeric,
    table.dataTable th.dt-type-date,
    table.dataTable td.dt-type-numeric,
    table.dataTable td.dt-type-date {
        text-align: left;
    }

    .row {
        display: -ms-flexbox;
        display: flex;
        -ms-flex-wrap: wrap;
        flex-wrap: wrap;
        margin-right: -7.5px;
        margin-left: -7.5px;
        flex-direction: column;
        justify-content: space-between;
    }


    /* Container that allows image to overflow on hover */
    .zoom-wrapper {
        position: relative;
        width: 60px;
        height: 60px;
        overflow: visible;
        /* allow zoom outside */
        z-index: 1;
    }

    /* Base image style */
    .zoom-img {
        width: 60px;
        height: 60px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-radius: 2px;
        z-index: 1;
        position: relative;
    }

    /* Zoom effect */
    .zoom-wrapper:hover .zoom-img {
        transform: scale(3);
        /* zoom 3x outward */
        position: absolute;
        top: -60px;
        /* shift up */
        left: 60px;
        /* shift left */
        z-index: 999;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        border: 2px solid #fff;
        background: #fff;
        border-radius: 6px;
    }

    .zoom-wrapper {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .zoom-wrapper img {
        width: 100px;
        height: 70px;
        object-fit: cover;
        transition: transform 0.3s ease;
        cursor: zoom-in;
    }

    .zoom-wrapper img:hover {
        transform: scale(2);
        /* Zoom level */
        z-index: 999;
        position: relative;
    }
</style>

<div class="content-wrapper" style="background-color:#fff;">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mt-2">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success"> <?php echo $this->session->flashdata('success'); ?> </div>
                    <?php elseif ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger"> <?php echo $this->session->flashdata('error'); ?> </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 text-right">
                    <a href="<?php echo base_url('admin/add-lapel-color'); ?>" class="btn btn-primary mb-2">Add New</a>
                </div>
            </div>

            <div class="row">
                <?php if (!empty($allLapelColors)): ?>
                    <table class="table table-bordered table-striped" id="myTable">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>Style</th>
                                <th>Jacket Lapel</th>
                                <th>Lapel Width</th>
                                <th>Color</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $serial_number = $page_no + 1; ?>
                            <?php foreach ($allLapelColors as $bi): ?>
                                <tr>
                                    <td><?php echo $serial_number++; ?></td>

                                    <td><?php echo $bi['style']; ?></td>

                                    <td><?php echo $bi['lapel']; ?></td>

                                    <td><?php echo $bi['lapel_width']; ?></td>

                                    <td>
                                        <?php if (!empty($bi['color'])): ?>
                                            <div class="zoom-wrapper">
                                                <img src="<?php echo base_url('uploads/blazer-initials/shadow-extras-thread1.png'); ?>" style="background-color: <?php echo '#' . $bi['color']; ?>" class="zoom-img" width="40" height="40">
                                            </div>
                                            <?php echo '#' . $bi['color']; ?>
                                        <?php else: ?>
                                            Not Available
                                        <?php endif; ?>
                                    </td>

                                    <td style="color: <?php echo $bi['status'] == 'Active' ? 'green' : 'red'; ?>;">
                                        <button type="button" title="Change status" onclick="beforeChangeStatus(<?php echo $bi['id']; ?>);" class="btn <?php echo $bi['status'] == 'InActive' ? 'btn-outline-danger' : 'btn-outline-success'; ?>">
                                            <i class="fas <?php echo $bi['status'] == 'InActive' ? 'fa-toggle-off' : 'fa-toggle-on'; ?>"></i>
                                        </button>
                                    </td>

                                    <td>
                                        <a href="<?php echo base_url('admin/edit-lapel-color/' . $bi['id']); ?>" class="btn btn-outline-secondary" title="Edit Records">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </td>


                                </tr>

                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="col-md-12 text-center">
                        <p>No records found</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
</div>

<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    function beforeChangeStatus(id) {
        swal({
            title: "Are you sure?",
            text: "You want to change the status.",
            icon: "warning",
            buttons: {
                cancel: 'Cancel',
                ok: {
                    text: "Yes",
                    value: true,
                },
            },
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: "<?php echo base_url('admin/lapel-color-status-update'); ?>",
                    type: "POST",
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function(response) {
                        location.reload();
                    },
                    error: function() {
                        alert('Error updating status.');
                    }
                });
            }
        });
    }
</script>


<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            pageLength: 10,
            lengthChange: true,
            ordering: true,
            autoWidth: false
        });
    });
</script>