<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<style>
    /* Container that allows image to overflow on hover */
    .zoom-wrapper {
        position: relative;
        width: 60px;
        height: 60px;
        overflow: visible;
        /* allow zoom outside */
        z-index: 1;
    }

    /* Base image style */
    .zoom-img {
        width: 60px;
        height: 60px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-radius: 2px;
        z-index: 1;
        position: relative;
    }

    /* Zoom effect */
    .zoom-wrapper:hover .zoom-img {
        transform: scale(3);
        /* zoom 3x outward */
        position: absolute;
        top: -60px;
        /* shift up */
        left: 60px;
        /* shift left */
        z-index: 999;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        border: 2px solid #fff;
        background: #fff;
        border-radius: 6px;
    }

    table.dataTable th.dt-type-numeric,
    table.dataTable th.dt-type-date,
    table.dataTable td.dt-type-numeric,
    table.dataTable td.dt-type-date {
        text-align: left;
    }

    .row {
        display: -ms-flexbox;
        display: flex;
        -ms-flex-wrap: wrap;
        flex-wrap: wrap;
        margin-right: -7.5px;
        margin-left: -7.5px;
        flex-direction: column;
        justify-content: space-between;
    }
</style>

<div class="content-wrapper" style="background-color:#fff;">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mt-2">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success"> <?php echo $this->session->flashdata('success'); ?> </div>
                    <?php elseif ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger"> <?php echo $this->session->flashdata('error'); ?> </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 text-right">
                    <a href="<?php echo base_url('admin/add-fabric'); ?>" class="btn btn-primary mb-2">Add New Fabric</a>
                </div>
            </div>

            <div class="row">
                <?php if (!empty($fabric)): ?>
                    <table class="table is-bordered is-striped is-narrow is-hoverable is-fullwidth text-righ" id="myTable">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>Fabric Image</th>
                                <th>Design No</th>
                                <th>Blend</th>
                                <th>Price</th>
                                <th>WashCare</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $serial_number = $page_no + 1; ?>
                            <?php foreach ($fabric as $f): ?>
                                <tr>
                                    <td><?php echo $serial_number++; ?></td>
                                    <td>
                                        <?php if (!empty($f['fabric_image'])): ?>
                                            <div class="zoom-wrapper">
                                                <img src="<?php echo S3_BASE_URL . S3_TYPE . '/fabric/' . $f['fabric_image']; ?>" class="zoom-img" width="60" height="60">
                                            </div>
                                        <?php else: ?>
                                            Not Available
                                        <?php endif; ?>
                                    </td>


                                    <td><?php echo $f['design_no']; ?></td>
                                    <td><?php echo $f['blend']; ?></td>
                                    <td>
                                        INR: ₹<?php echo $f['price_inr']; ?><br>
                                        <!-- USD: $<?php echo $f['price_usd']; ?><br>
                                        GBP: £<?php echo $f['price_gbp']; ?><br>
                                        EUR: €<?php echo $f['price_euro']; ?> -->
                                    </td>
                                    <td><?php echo $f['washcare']; ?></tdz>
                                    <td><?php echo date('d-m-Y', strtotime($f['created_at'])); ?></td>

                                    <td style="color: <?php echo $f['status'] == 'Active' ? 'green' : 'red'; ?>;">
                                        <button type="button" title="Change status" onclick="beforeChangeStatus(<?php echo $f['fabric_id']; ?>);" class="btn <?php echo $f['status'] == 'InActive' ? 'btn-outline-danger' : 'btn-outline-success'; ?>">
                                            <i class="fas <?php echo $f['status'] == 'InActive' ? 'fa-toggle-off' : 'fa-toggle-on'; ?>"></i>
                                        </button>
                                    </td>

                                    <td>
                                        <a href="<?php echo base_url('admin/edit-fabric/' . $f['fabric_id']); ?>" class="btn btn-outline-secondary" title="Edit Records">
                                            <i class="fas fa-edit"></i>
                                        </a>

                                        <button type="button" class="btn btn-outline-primary" data-toggle="modal" data-target="#viewModal_<?php echo $f['fabric_id']; ?>" title="view Records">
                                            <i class="fas fa-eye"></i>
                                        </button>

                                        <a href="<?php echo base_url('admin/style/' . $f['fabric_id']); ?>" class="btn btn-outline-secondary" title="Add Style">
                                            <i class="fas fa-plus"></i>
                                        </a>


                                    </td>


                                </tr>

                                <!-- View Modal -->
                                <!-- Fabric Details Modal -->
                                <!-- Fabric Details Modal -->
                                <div class="modal fade" id="viewModal_<?= $f['fabric_id']; ?>" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel_<?= $f['fabric_id']; ?>" aria-hidden="true">
                                    <div class="modal-dialog modal-lg" role="document">
                                        <div class="modal-content">

                                            <!-- Modal Header -->
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="viewModalLabel_<?= $f['fabric_id']; ?>">Fabric Details</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>

                                            <!-- Modal Body -->
                                            <div class="modal-body">
                                                <div class="row mb-2">
                                                    <div class="col-md-4"><strong>Design No:</strong></div>
                                                    <div class="col-md-8"><?= $f['design_no']; ?></div>
                                                </div>

                                                <div class="row mb-2">
                                                    <div class="col-md-4"><strong>Blend:</strong></div>
                                                    <div class="col-md-8"><?= $f['blend']; ?></div>
                                                </div>

                                                <div class="row mb-2">
                                                    <div class="col-md-4"><strong>Prices:</strong></div>
                                                    <div class="col-md-8">
                                                        INR: ₹<?= $f['price_inr']; ?><br>
                                                        USD: $<?= $f['price_usd']; ?><br>
                                                        GBP: £<?= $f['price_gbp']; ?><br>
                                                        EUR: €<?= $f['price_euro']; ?>
                                                    </div>
                                                </div>

                                                <div class="row mb-2">
                                                    <div class="col-md-4"><strong>Washcare:</strong></div>
                                                    <div class="col-md-8"><?= $f['washcare']; ?></div>
                                                </div>

                                                <div class="row mb-2">
                                                    <div class="col-md-4"><strong>Image:</strong></div>
                                                    <div class="col-md-8">
                                                        <?php if (!empty($f['fabric_image'])): ?>
                                                            <img src="<?= base_url('uploads/fabric/' . $f['fabric_image']); ?>" width="100" alt="Fabric Image">
                                                        <?php else: ?>
                                                            No Image
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>


                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="col-md-12 text-center">
                        <p>No records found</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
</div>

<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    function beforeChangeStatus(fabric_id) {
        swal({
            title: "Are you sure?",
            text: "You want to change the status.",
            icon: "warning",
            buttons: {
                cancel: 'Cancel',
                ok: {
                    text: "Yes",
                    value: true,
                },
            },
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: "<?php echo base_url('admin/fabric-status-update'); ?>",
                    type: "POST",
                    data: {
                        fabric_id: fabric_id
                    },
                    dataType: 'json',
                    success: function(response) {
                        location.reload();
                    },
                    error: function() {
                        alert('Error updating status.');
                    }
                });
            }
        });
    }
</script>
<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            pageLength: 10,
            lengthChange: true,
            ordering: true,
            autoWidth: false
        });
    });
</script>