<style>
    .table thead th {
        vertical-align: bottom;
        border-bottom: 2px solid #bec6cf;
        background: #000000db;
        color: white;
    }

    div#myTable_wrapper {
        width: 100%;
    }

    .cke_notifications_area {
        display: none !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        background-color: #007bff;
        color: rgb(22, 18, 18) !important;
        border: 1px solid #007bff;
    }

    .select2-results__option[aria-selected=true] {
        background-color: #f0f0f0;
        color: rgb(22, 18, 18) !important;
    }
</style>

<div class="content-wrapper" style="background-color: #f8f9fa; min-height: 100vh;">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mt-2">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success"><?php echo $this->session->flashdata('success'); ?></div>
                    <?php elseif ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <!-- <?php //print_r($UpdateStyle); ?> -->
    <div class="container mt-4">
        <div class="bg-white p-4 shadow-sm rounded">
            <div class="row">
                <div class="col-md-12 mb-3 text-right">
                    <a href="<?php echo base_url('admin/style'); ?>" class="btn btn-primary">Back to Style List</a>
                </div>

                <!-- ===== Fabric Add Form ===== -->
                <form method="POST" action="<?php echo base_url('admin/update-style'); ?>" enctype="multipart/form-data" class="w-100 row">
                    <?php $value = $UpdateStyle; ?>

                    <input type="hidden" name="fabric_id" value="<?php echo $value['fabric_id']; ?>">
                    <input type="hidden" name="id" value="<?php echo $value['id']; ?>">

                    <!-- Fabric Name Dropdown -->
                    <div class="form-group col-lg-6">
                        <label for="fabric_id">Fabric Name</label>
                        <select class="form-control" name="fabric_id" id="fabric_id" required>
                            <option value="">Select Fabric Name</option>
                            <?php foreach ($fabricName as $row): ?>
                                <option value="<?php echo $row->fabric_id; ?>"
                                    <?php echo ($row->fabric_id == $UpdateStyle['fabric_id']) ? 'selected' : ''; ?>>
                                    <?php echo $row->design_no; ?>
                                </option>
                            <?php endforeach; ?>

                        </select>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>Style Title</label>
                            <input class="form-control" type="text" name="style_title"
                                value="<?php echo isset($value['style_title']) ? $value['style_title'] : ''; ?>"
                                required placeholder="Enter Style Title">
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>Style Image (Max 2Mb)</label>
                            <input type="file" name="style_image" accept="image/*" class="form-control mb-2">

                            <?php if (!empty($value['style_image'])): ?>
                                <img src="<?php echo base_url('uploads/fabric/' . $value['style_image']); ?>" width="100" class="mb-2" alt="Style Image">
                            <?php endif; ?>
                        </div>
                    </div>

                         <div class="col-lg-6">
                        <div class="form-group">
                            <label>Extra Image (Max 2Mb)</label>
                            <input type="file" name="extra_image" accept="image/*" class="form-control mb-2">

                            <?php if (!empty($value['extra_image'])): ?>
                                <img src="<?php echo base_url('uploads/fabric/' . $value['extra_image']); ?>" width="100" class="mb-2" alt="Extra Image">
                            <?php endif; ?>
                        </div>
                    </div>



                    <div class="col-lg-12 d-flex justify-content-center">
                        <button type="submit" class="btn btn-primary mt-3">Update Style</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>

<script>
    document.querySelectorAll('input[type="number"]').forEach(function(input) {
        input.addEventListener('input', function() {
            this.value = this.value.replace(/[^0-9.]/g, '');
        });
    });
</script>