<style>
    .table thead th {
        vertical-align: bottom;
        border-bottom: 2px solid #bec6cf;
        background: #000000db;
        color: white;
    }

    div#myTable_wrapper {
        width: 100%;
    }

    .cke_notifications_area {
        display: none !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        background-color: #007bff;
        color: rgb(22, 18, 18) !important;
        border: 1px solid #007bff;
    }

    .select2-results__option[aria-selected=true] {
        background-color: #f0f0f0;
        color: rgb(22, 18, 18) !important;
    }
</style>

<div class="content-wrapper" style="background-color: #f8f9fa; min-height: 100vh;">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mt-2">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success"><?php echo $this->session->flashdata('success'); ?></div>
                    <?php elseif ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-4">
        <div class="bg-white p-4 shadow-sm rounded">
            <div class="row">
                <div class="col-md-12 mb-3 text-right">
                    <a href="<?php echo base_url('admin/fabric'); ?>" class="btn btn-primary">Back to Fabric List</a>
                </div>

                <!-- ===== Fabric Add Form ===== -->
                <form method="POST" action="<?php echo base_url('admin/update-fabric'); ?>" enctype="multipart/form-data" class="w-100 row">
                    <?php $value = $UpdateFabric; ?>

                    <input type="hidden" name="fabric_id" value="<?php echo $value['fabric_id']; ?>">

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>Design No</label>
                            <input class="form-control" type="text" name="design_no" value="<?php echo $value['design_no']; ?>" required placeholder="Enter Design No">
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>Blend</label>
                            <input class="form-control" type="text" name="blend" value="<?php echo $value['blend']; ?>" required placeholder="Enter Blend">
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>Price (INR)</label>
                            <input class="form-control" type="number" step="0.01" min="0" name="price_inr"
                                value="<?php echo htmlspecialchars($value['price_inr']); ?>"
                                required placeholder="Enter Price (INR)">
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>Price (USD)</label>
                            <input class="form-control" type="number" step="0.01" min="0" name="price_usd"
                                value="<?php echo htmlspecialchars($value['price_usd']); ?>"
                                required placeholder="Enter Price (USD)">
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>Price (GBP)</label>
                            <input class="form-control" type="number" step="0.01" min="0" name="price_gbp"
                                value="<?php echo htmlspecialchars($value['price_gbp']); ?>"
                                required placeholder="Enter Price (GBP)">
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>Price (EURO)</label>
                            <input class="form-control" type="number" step="0.01" min="0" name="price_euro"
                                value="<?php echo htmlspecialchars($value['price_euro']); ?>"
                                required placeholder="Enter Price (EURO)">
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>Washcare</label>
                            <input class="form-control" type="text" name="washcare" value="<?php echo $value['washcare']; ?>" required placeholder="Enter Washcare Instructions">
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>Fabric Image (Max 2Mb)</label><br>
                            <?php if (!empty($value['fabric_image'])): ?>
                                <img src="<?php echo S3_BASE_URL . S3_TYPE . '/fabric/' . $value['fabric_image']; ?>" width="100" class="mb-2"><br>
                            <?php endif; ?>
                            <input type="file" name="fabric_image" accept="image/*" class="form-control">
                        </div>
                    </div>

                    <div class="col-lg-12 d-flex justify-content-center">
                        <button type="submit" class="btn btn-primary mt-3">Update Fabric</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>

<script>
    document.querySelectorAll('input[type="number"]').forEach(function(input) {
        input.addEventListener('input', function() {
            this.value = this.value.replace(/[^0-9.]/g, '');
        });
    });
</script>