<style>
    .small-box {
        position: relative;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        border-radius: 16px;
        padding: 20px;
        text-align: center;
        backdrop-filter: blur(10px);
        background: linear-gradient(145deg, rgb(255, 255, 255), rgb(255, 255, 255));
        /* cool light blue tones */
        border: 1px solid rgba(26, 46, 87, 0.2);
        /* soft royal blue border */
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
        transition: 0.3s ease-in-out;
        overflow: hidden;
        color: #1a2e57;
    }

    .small-box:hover {
        transform: translateY(-5px);
        background: linear-gradient(145deg, #e0eaf8, #f5f9ff);
        /* lighter blue on hover */
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.15);
        border-color: rgba(26, 46, 87, 0.4);
    }

    .small-box .inner h3 {
        font-size: 2rem;
        font-weight: bold;
        margin: 0;
        color: #0d1c3e;
    }

    .small-box .inner p a {
        font-size: 1.1rem;
        margin-top: 5px;
        color: #1a2e57;
        font-weight: 500;
        text-decoration: none;
    }

    .small-box .inner p a:hover {
        color: #234c8b;
    }

    .small-box .icon {
        width: 50px;
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: center;
        position: absolute;
        top: 15px;
        right: 15px;
        background: rgba(26, 46, 87, 0.08);
        /* soft blue glow */
        border-radius: 50%;
        font-size: 20px;
        color: #1a2e57;
        transition: 0.3s;
    }

    .content-wrapper {
        background: linear-gradient(to right, #f0f4fa, #ffffff);
        /* soft blue-white gradient */
    }

    .content-header h1 {
        color: #1a2e57;
    }
</style>


<div class="content-wrapper" style="min-height: 319px;">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"></h1>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">

                <div class="container-fluid">
                    <div class="row">
                        <!-- Stat Cards -->
                        <div class="col-lg-3 col-6">
                            <div class="small-box">
                                <div class="inner">
                                    <h3><?php echo count($fabricCount); ?></h3>
                                    <p><a href="<?php echo base_url('admin/fabric'); ?>">Total Fabrics</a></p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-tshirt"></i>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-6">
                            <div class="small-box">
                                <div class="inner">
                                    <h3>320</h3>
                                    <p><a href="<?php echo base_url('admin/orders'); ?>">Total Orders</a></p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-shopping-bag"></i>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-6">
                            <div class="small-box">
                                <div class="inner">
                                    <h3><?php echo count($buttonCount); ?></h3>
                                    <p><a href="<?php echo base_url('admin/button'); ?>">Total Buttons</a></p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-circle-dot"></i>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-6">
                            <div class="small-box">
                                <div class="inner">
                                    <h3>75</h3>
                                    <p><a href="<?php echo base_url('admin/users'); ?>">Customers</a></p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-users"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Charts -->
                    <div class="row">
                        <!-- Sales Bar Chart -->
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Monthly Sales Overview</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="salesChart" height="150"></canvas>
                                </div>
                            </div>
                        </div>

                        <!-- Orders Pie Chart -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Order Status</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="ordersPieChart" height="200"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Orders Table -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card mt-4">
                                <div class="card-header">
                                    <h3 class="card-title">Recent Orders</h3>
                                </div>
                                <div class="card-body table-responsive">
                                    <table class="table table-hover text-nowrap">
                                        <thead>
                                            <tr>
                                                <th>Order ID</th>
                                                <th>Customer</th>
                                                <th>Status</th>
                                                <th>Total</th>
                                                <th>Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>#ORD00123</td>
                                                <td>John Doe</td>
                                                <td><span class="badge bg-success">Completed</span></td>
                                                <td>₹1,250</td>
                                                <td>08 Jul 2025</td>
                                            </tr>
                                            <tr>
                                                <td>#ORD00124</td>
                                                <td>Jane Smith</td>
                                                <td><span class="badge bg-warning">Pending</span></td>
                                                <td>₹980</td>
                                                <td>08 Jul 2025</td>
                                            </tr>
                                            <tr>
                                                <td>#ORD00125</td>
                                                <td>Rahul Verma</td>
                                                <td><span class="badge bg-danger">Cancelled</span></td>
                                                <td>₹1,540</td>
                                                <td>07 Jul 2025</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </section>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    // Monthly Sales Chart
    const salesCtx = document.getElementById('salesChart').getContext('2d');
    const salesChart = new Chart(salesCtx, {
        type: 'bar',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul'],
            datasets: [{
                label: 'Revenue (₹)',
                data: [12000, 15000, 11000, 17000, 14000, 19000, 21000],
                backgroundColor: '#1a2e57',
                borderRadius: 10
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Orders Pie Chart
    const pieCtx = document.getElementById('ordersPieChart').getContext('2d');
    const ordersPieChart = new Chart(pieCtx, {
        type: 'pie',
        data: {
            labels: ['Completed', 'Pending', 'Cancelled'],
            datasets: [{
                data: [60, 25, 15],
                backgroundColor: ['#28a745', '#ffc107', '#dc3545']
            }]
        },
        options: {
            responsive: true
        }
    });
</script>