<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<style>
    div#myTable_wrapper {
        width: 100%;
    }

    table.dataTable th.dt-type-numeric,
    table.dataTable th.dt-type-date,
    table.dataTable td.dt-type-numeric,
    table.dataTable td.dt-type-date {
        text-align: left;
    }

    /* Container that allows image to overflow on hover */
    .zoom-wrapper {
        position: relative;
        width: 60px;
        height: 60px;
        overflow: visible;
        /* allow zoom outside */
        z-index: 1;
    }

    /* Base image style */
    .zoom-img {
        width: 60px;
        height: 60px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-radius: 2px;
        z-index: 1;
        position: relative;
    }

    /* Zoom effect */
    .zoom-wrapper:hover .zoom-img {
        transform: scale(3);
        /* zoom 3x outward */
        position: absolute;
        top: -60px;
        /* shift up */
        left: 60px;
        /* shift left */
        z-index: 999;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        border: 2px solid #fff;
        background: #fff;
        border-radius: 6px;
    }

    .zoom-wrapper {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .zoom-wrapper img {
        width: 60px;
        height: 60px;
        object-fit: cover;
        transition: transform 0.3s ease;
        cursor: zoom-in;
    }

    .zoom-wrapper img:hover {
        transform: scale(2);
        /* Zoom level */
        z-index: 999;
        position: relative;
    }
</style>

<div class="content-wrapper" style="background-color:#fff;">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mt-2">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success"> <?php echo $this->session->flashdata('success'); ?> </div>
                    <?php elseif ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger"> <?php echo $this->session->flashdata('error'); ?> </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 text-right">
                    <a href="<?php echo base_url('admin/add-button'); ?>" class="btn btn-primary mb-2">Add New Button</a>
                </div>
            </div>

            <!-- <?php //print_r($button);
                    ?> -->

            <div class="row">
                <?php if (!empty($button)): ?>
                    <table class="table table-bordered table-striped" id="myTable">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>Style Title</th>
                                <th>Button Image / Name</th>
                                <th>Display Image</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $serial_number = $page_no + 1; ?>
                            <?php foreach ($button as $b): ?>
                                <tr>
                                    <td><?php echo $serial_number++; ?></td>
                                    <td><?php echo $b['style_title']; ?></td>
                                    <td>
                                        <?php if (!empty($b['image'])): ?>
                                            <div class="d-flex align-items-center">
                                                <div class="zoom-wrapper">
                                                    <img src="<?php echo base_url('uploads/buttons/' . $b['image']); ?>" alt="Button Image">

                                                </div>
                                                <span><?php echo $b['button_color']; ?></span>
                                            </div>
                                        <?php else: ?>
                                            <span><?php echo $b['button_color']; ?> (No Image)</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if (!empty($b['display_image'])): ?>
                                            <div class="zoom-wrapper">
                                                <img src="<?php echo base_url('uploads/buttons/' . $b['display_image']); ?>" alt="Display Image" width="100">
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo date('d-m-Y', strtotime($b['created_at'])); ?></td>

                                    <td style="color: <?php echo $b['status'] == 'Active' ? 'green' : 'red'; ?>;">
                                        <button type="button" title="Change status" onclick="beforeChangeStatus(<?php echo $b['id']; ?>);" class="btn <?php echo $b['status'] == 'InActive' ? 'btn-outline-danger' : 'btn-outline-success'; ?>">
                                            <i class="fas <?php echo $b['status'] == 'InActive' ? 'fa-toggle-off' : 'fa-toggle-on'; ?>"></i>
                                        </button>
                                    </td>

                                    <td>
                                        <a href="<?php echo base_url('admin/edit-button/' . $b['id']); ?>" class="btn btn-outline-secondary" title="Edit Records">
                                            <i class="fas fa-edit"></i>
                                        </a>

                                    </td>


                                </tr>

                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="col-md-12 text-center">
                        <p>No records found</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
</div>

<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    function beforeChangeStatus(id) {
        swal({
            title: "Are you sure?",
            text: "You want to change the status.",
            icon: "warning",
            buttons: {
                cancel: 'Cancel',
                ok: {
                    text: "Yes",
                    value: true,
                },
            },
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: "<?php echo base_url('admin/button-status-update'); ?>",
                    type: "POST",
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function(response) {
                        location.reload();
                    },
                    error: function() {
                        alert('Error updating status.');
                    }
                });
            }
        });
    }
</script>

<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            pageLength: 10,
            lengthChange: true,
            ordering: true,
            autoWidth: false
        });
    });
</script>