<style>
    .table thead th {
        vertical-align: bottom;
        border-bottom: 2px solid #bec6cf;
        background: #000000db;
        color: white;
    }

    div#myTable_wrapper {
        width: 100%;
    }

    .cke_notifications_area {
        display: none !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        background-color: #007bff;
        color: rgb(22, 18, 18) !important;
        border: 1px solid #007bff;
    }

    .select2-results__option[aria-selected=true] {
        background-color: #f0f0f0;
        color: rgb(22, 18, 18) !important;
    }
</style>

<div class="content-wrapper" style="background-color: #f8f9fa; min-height: 100vh;">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mt-2">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success"><?php echo $this->session->flashdata('success'); ?></div>
                    <?php elseif ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-4">
        <div class="bg-white p-4 shadow-sm rounded">
            <div class="row">
                <div class="col-md-12 mb-3 text-right">
                    <a href="<?php echo base_url('admin/linings'); ?>" class="btn btn-primary">Back to List</a>
                </div>

                <!-- ===== Fabric Add Form ===== -->
                <form method="POST" action="<?php echo base_url('admin/save-lining'); ?>" enctype="multipart/form-data" class="w-100 row">

                    <input type="hidden" name="lining_id" value="<?php echo $liningData->id ?>">

                    <!-- Fabric Name Dropdown -->
                    <div class="form-group col-lg-6">
                        <label for="type">Type</label>
                        <select class="form-control" name="type" id="type" required>
                            <option value="">Select Type</option>
                            <option value="Full lining" <?php echo $liningData->type == 'Full lining' ? 'selected' : ''; ?>>Full lining</option>
                            <option value="Half lining" <?php echo $liningData->type == 'Half lining' ? 'selected' : ''; ?>>Half lining</option>
                            <option value="Unlined" <?php echo $liningData->type == 'Unlined' ? 'selected' : ''; ?>>Unlined</option>
                        </select>
                    </div>

                    <!-- Style Title Input -->
                    <div class="form-group col-lg-6">
                        <label for="fabric_name">Fabric Name</label>
                        <input type="text" class="form-control" name="fabric_name" id="fabric_name" value="<?php echo $liningData->fabric_name; ?>" required placeholder="Berck">
                    </div>

                    <!-- Style Image Input -->
                    <div class="form-group col-lg-6">
                        <label for="blend">Blend</label>
                        <input type="text" class="form-control" name="blend" id="blend" placeholder="Polyester" value="<?php echo $liningData->blend; ?>" required>
                    </div>

                    <div class="form-group col-lg-6">
                        <label for="fabric_image">Fabric Display Image</label>
                        <input type="file" class="form-control" name="fabric_image" id="fabric_image" <?php echo !$liningData->fabric_image ? 'required' : ''; ?>>
                        <?php if ($flag == 'edit') { ?>
                            <div class="color-div">
                                <div class="check">Current: <img src="<?php echo S3_BASE_URL . S3_TYPE .'/' . strtolower(str_replace("+", "%2B", $liningData->fabric_image)); ?>" style="width: 150px;"></div>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="form-group col-lg-6">
                        <label for="top_image">Fabric Top Image</label>
                        <input type="file" class="form-control" name="top_image" id="top_image" <?php echo !$liningData->top_image ? 'required' : ''; ?>>
                        <?php if ($flag == 'edit') { ?>
                            <div class="color-div">
                                <div class="check">Current: <img src="<?php echo S3_BASE_URL . S3_TYPE .'/' . strtolower(str_replace("+", "%2B", $liningData->top_image)); ?>" style="width: 150px;"></div>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="form-group col-lg-6">
                        <label for="bottom_image">Fabric Bottom Image</label>
                        <input type="file" class="form-control" name="bottom_image" id="bottom_image" <?php echo !$liningData->bottom_image ? 'required' : ''; ?>>
                        <?php if ($flag == 'edit') { ?>
                            <div class="color-div">
                                <div class="check">Current: <img src="<?php echo S3_BASE_URL . S3_TYPE .'/' . strtolower(str_replace("+", "%2B", $liningData->bottom_image)); ?>" style="width: 150px;"></div>
                            </div>
                        <?php } ?>
                    </div>

                    <!-- Submit Button -->
                    <div class="col-lg-12 d-flex justify-content-center">
                        <button type="submit" class="btn btn-primary mt-3">Save</button>
                    </div>
                </form>


            </div>
        </div>
    </div>
</div>