<style>
    .table thead th {
        vertical-align: bottom;
        border-bottom: 2px solid #bec6cf;
        background: #000000db;
        color: white;
    }

    .row {
        display: -ms-flexbox;
        display: flex;
        -ms-flex-wrap: wrap;
        flex-wrap: wrap;
        margin-right: -7.5px;
        margin-left: -7.5px;
        flex-direction: column;
        justify-content: space-between;
    }


    div#myTable_wrapper {
        width: 100%;
    }

    .cke_notifications_area {
        display: none !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        background-color: #007bff;
        color: rgb(22, 18, 18) !important;
        border: 1px solid #007bff;
    }

    .select2-results__option[aria-selected=true] {
        background-color: #f0f0f0;
        color: rgb(22, 18, 18) !important;
    }
</style>

<div class="content-wrapper" style="background-color: #f8f9fa; min-height: 100vh;">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mt-2">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success"><?php echo $this->session->flashdata('success'); ?></div>
                    <?php elseif ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-4">
        <div class="bg-white p-4 shadow-sm rounded">
            <div class="row">
                <div class="col-md-12 mb-3 text-right">
                    <a href="<?php echo base_url('admin/button'); ?>" class="btn btn-primary">Back to Button List</a>
                </div>

            </div>
            <div class="">
                <form method="POST" action="<?php echo base_url('admin/save-button'); ?>" enctype="multipart/form-data" class="w-100 row flex-row">

                    <!-- Style Name Dropdown -->
                    <div class="form-group col-6">
                        <label for="fabric_id">Style Name</label>
                        <select class="form-control" name="style_title" id="style_title" required>
                            <option value="">Select Fabric Name</option>
                            <?php foreach ($styleName as $row): ?>
                                <option value="<?php echo $row['style_title']; ?>"><?php echo $row['style_title']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-6">
                        <div class="form-group">
                            <label>Button Name</label>
                            <input class="form-control" type="text" name="button_color" required placeholder="Enter Button Color">
                        </div>
                    </div>

                    <div class="col-6">
                        <div class="form-group">
                            <label>Button Image (Max 2Mb)</label>
                            <input type="file" name="image" accept="*" class="form-control" required>
                        </div>
                    </div>

                    <div class="col-6">
                        <div class="form-group">
                            <label>Display Image (Max 2Mb)</label>
                            <input type="file" name="display_image" accept="*" class="form-control" required>
                        </div>
                    </div>

                    <div class="col-12 d-flex justify-content-center">
                        <button type="submit" class="btn btn-primary mt-3">Save Button</button>
                    </div>


                </form>
            </div>
        </div>
    </div>
</div>

<script>
    document.querySelectorAll('input[type="number"]').forEach(function(input) {
        input.addEventListener('input', function() {
            this.value = this.value.replace(/[^0-9.]/g, '');
        });
    });
</script>