<style>
    .table thead th {
        vertical-align: bottom;
        border-bottom: 2px solid #bec6cf;
        background: #000000db;
        color: white;
    }

    div#myTable_wrapper {
        width: 100%;
    }

    .cke_notifications_area {
        display: none !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        background-color: #007bff;
        color: rgb(22, 18, 18) !important;
        border: 1px solid #007bff;
    }

    .select2-results__option[aria-selected=true] {
        background-color: #f0f0f0;
        color: rgb(22, 18, 18) !important;
    }
</style>

<div class="content-wrapper" style="background-color: #f8f9fa; min-height: 100vh;">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mt-2">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success"><?php echo $this->session->flashdata('success'); ?></div>
                    <?php elseif ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-4">
        <div class="bg-white p-4 shadow-sm rounded">
            <div class="row">
                <div class="col-md-12 mb-3 text-right">
                    <a href="<?php echo base_url('admin/button-hole'); ?>" class="btn btn-primary">Back to Button Hole List</a>
                </div>

                <!-- ===== Fabric Add Form ===== -->
                <form method="POST" action="<?php echo base_url('admin/save-button-hole'); ?>" enctype="multipart/form-data" class="w-100 row">


                    <!-- Hidden field for selected fabric ID -->
                    <input type="hidden" name="fabric_id" value="<?php echo $fabric_id; ?>">
                    <input type="hidden" name="id" value="<?php echo $id; ?>">


                    <div class="form-group col-lg-6">
                        <label for="fabric_id">Fabric Name</label>
                        <select class="form-control" name="fabric_id" id="fabric_id" required onchange="getStylesByFabric(this.value)">
                            <option value="">Select Fabric Name</option>
                            <?php foreach ($fabricName as $row): ?>
                                <option value="<?php echo $row->fabric_id; ?>">
                                    <?php echo $row->design_no; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Style Name Dropdown -->
                    <div class="form-group col-lg-6">
                        <label for="style_id">Style Name</label>
                        <select class="form-control" name="style_id" id="id" required>
                            <option value="">Select Style Name</option>
                        </select>
                    </div>

                    <!-- Style Title Input -->
                    <div class="form-group col-lg-6">
                        <label for="style_title">Button Hole Title</label>
                        <input type="text" class="form-control" name="button_hole_name" id="button_hole_name" required placeholder="Enter Button Hole Title">
                    </div>

                    <!-- Style Image Input -->
                    <div class="form-group col-lg-6">
                        <label for="image">Sleeve button Image (Max 2Mb)</label>
                        <input type="file" class="form-control" name="image" id="image" accept="image/*" required>
                    </div>

                       <!-- Style Image Input -->
                    <div class="form-group col-lg-6">
                        <label for="image">Display Image (Max 2Mb)</label>
                        <input type="file" class="form-control" name="extra_image" id="extra_image" accept="image/*" required>
                    </div>


                    <!-- Submit Button -->
                    <div class="col-lg-12 d-flex justify-content-center">
                        <button type="submit" class="btn btn-primary mt-3">Save Button Hole</button>
                    </div>
                </form>


            </div>
        </div>
    </div>
</div>


<!-- AJAX Script -->

<!-- get style name against fabric  -->
<script>
function getStylesByFabric(fabricId) {
    if (fabricId !== "") {
        fetch("<?php echo base_url('admin/get-styles-by-fabric/'); ?>" + fabricId)
        .then(response => response.json())
        .then(data => {
            let styleDropdown = document.getElementById("id");
            styleDropdown.innerHTML = '<option value="">Select Style Name</option>';
            data.forEach(function(style) {
                let option = document.createElement("option");
                option.value = style.id;
                option.text = style.style_title;
                styleDropdown.appendChild(option);
            });
        });
    } else {
        document.getElementById("id").innerHTML = '<option value="">Select Style Name</option>';
    }
}
</script>

