<?php
class UserModel extends CI_Model
{

    public function login($condition)
    {
        return $this->db->select('*')->from('tb_login')->where($condition)->get()->row();
    }
    public function insert_user($data)
    {
        return $this->db->insert('tb_login', $data);
    }
    // public function get_user_by_email($email) {
    //     return $this->db->where('email', $email)->get('tbl_users')->row();
    // }

    public function updateUserProfile($id, $data)
    {
        $this->db->where('login_id', $id);
        return $this->db->update('tb_login', $data);
    }

    public function get_user_by_email($email)
    {
        return $this->db->where('email', $email)->get('tb_login')->row();
    }
    public function save_reset_token($email, $token)
    {
        return $this->db->where('email', $email)->update('tb_login', ['reset_token' => $token]);
    }
    public function get_user_by_token($token)
    {
        return $this->db->where('reset_token', $token)->get('tb_login')->row();
    }
    public function update_password_by_token($token, $password)
    {
        return $this->db->where('reset_token', $token)->update('tb_login', [
            'password'     => $password,
            'reset_token'  => null
        ]);
    }

    public function getCustomerDetails()
    {

        $query = $this->db->query("SELECT * FROM tb_fabric WHERE status='Active'  ORDER BY fabric_id  ASC");
        return $query->result_array();
    }

    public function getStyle()
    {

        // $query = $this->db->query("SELECT style_title, extra_image, style_image FROM tb_style WHERE status='Active'  GROUP BY style_title ORDER BY style_title ASC");
        // return $query->result_array();
        $query = $this->db->query("
    SELECT s1.*
    FROM tb_style s1
    INNER JOIN (
        SELECT MIN(id) as min_id
        FROM tb_style
        WHERE status='Active'
        GROUP BY style_title
    ) s2 ON s1.id = s2.min_id
    ORDER BY s1.style_title ASC
");
        return $query->result_array();
    }
    public function getPocketStyle()
    {
        $query = $this->db->query("
        SELECT 
            pocket_style_name, 
            MIN(extra_image) AS extra_image, 
            MIN(image) AS image 
        FROM tb_pocket_style 
        WHERE status='Active' 
        GROUP BY pocket_style_name 
        ORDER BY pocket_style_name ASC
    ");
        return $query->result_array();
    }



    public function getjacketLapels()
    {

        $query = $this->db->query("
    SELECT 
        jacket_lapels_title, 
        MIN(image) AS image, 
        MIN(extra_image) AS extra_image 
    FROM tb_jacket_lapels 
    WHERE status='Active' 
    GROUP BY jacket_lapels_title 
    ORDER BY jacket_lapels_title ASC
");
        return $query->result_array();
    }

    public function getlapelWidth()
    {

        $query = $this->db->query("
    SELECT 
        lapel_width_title, 
        MIN(image) AS image, 
        MIN(extra_image) AS extra_image 
    FROM tb_lapel_width 
    WHERE status='Active' 
    GROUP BY lapel_width_title 
    ORDER BY lapel_width_title ASC
");
        return $query->result_array();
    }


    public function getBackStyle()
    {

        $query = $this->db->query("
    SELECT 
        back_style_name, 
        MIN(image) AS image, 
        MIN(extra_image) AS extra_image 
    FROM tb_back_style 
    WHERE status='Active' 
    GROUP BY back_style_name 
    ORDER BY back_style_name ASC
");
        return $query->result_array();
    }


    public function getBreastPocket()
    {

        $query = $this->db->query("
    SELECT 
        breast_pocket_name, 
        MIN(image) AS image, 
        MIN(extra_image) AS extra_image 
    FROM tb_breast_pocket 
    WHERE status='Active' 
    GROUP BY breast_pocket_name 
    ORDER BY breast_pocket_name ASC
");
        return $query->result_array();
    }

    public function getThreadColor()
    {

        $query = $this->db->query("SELECT * FROM tb_blazer_initials WHERE status='Active'  Order BY id  ASC");
        return $query->result_array();
    }


    public function getElbowPatches()
    {
        return $this->db->get('tb_elbow_patches')->result_array();
    }

    public function getLinings($type)
    {
        return $this->db->get_where('tbl_lining', ['type' => $type])->result_array();
    }

   


}
