<?php
class AdminModel extends CI_Model
{
    public function login($condition)
    {
        return $this->db->select('*')->from('tbl_users')->where($condition)->get()->row();
    }

    public function getAllFabrics()
    {
        return $this->db->order_by('fabric_id ', 'DESC')->get('tb_fabric')->result_array();
    }


    public function insertFabric($data)
    {
        return $this->db->insert('tb_fabric', $data);
    }

    public function FabricStatusUpdate($fabric_id)
    {
        $currentStatus = $this->db->select('status')->from('tb_fabric')->where('fabric_id', $fabric_id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('fabric_id', $fabric_id);
        $this->db->update('tb_fabric', $data);
        return $this->db->affected_rows();
    }

    public function UpdateFabric($fabric_id)
    {
        $this->db->select('*');
        $this->db->from('tb_fabric');
        $this->db->where('fabric_id', $fabric_id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }

    public function updatefabricDetails($data, $fabric_id)
    {
        $this->db->where('fabric_id', $fabric_id);
        return $this->db->update('tb_fabric', $data);
    }


    //style


    public function getAllFabricAgainstStyle($fabric_id = "")
    {
        $this->db->select('f.fabric_id, f.design_no, s.*');
        $this->db->from('tb_style s');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');

        if (!empty($fabric_id)) {
            $this->db->where('f.fabric_id', $fabric_id);
        }

        $this->db->order_by('s.id', 'DESC'); // Order styles by ID descending

        $query = $this->db->get();
        return $query->result_array();
    }

    public function getAllFabricName()
    {
        $this->db->select('*');
        $this->db->from('tb_fabric');
        $this->db->order_by('fabric_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }


    public function getAllFabric()
    {
        $this->db->select('*');
        $this->db->from('tb_fabric');
        $this->db->order_by('fabric_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }


    // public function getAllFabricAgainstStyle()
    // {
    //     return $this->db->order_by('id ', 'DESC')->get('tb_style')->result_array();
    // }


    public function Addstyle($fabric_id)
    {
        return $this->db->get_where('tb_fabric', ['fabric_id' => $fabric_id])->row_array();
    }


    public function insertStyle($data)
    {
        return $this->db->insert('tb_style', $data);
    }

    public function styleStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_style')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_style', $data);
        return $this->db->affected_rows();
    }


    public function UpdateStyle($id)
    {
        $this->db->select('*');
        $this->db->from('tb_style');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }

    public function updateStyleFabricWise($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('tb_style', $data);
    }


    //Jacket Lapels

    public function getAllJacketLapels()
    {
        $this->db->select('
        jl.id AS lapel_id,
        jl.jacket_lapels_title,
        jl.image,
        jl.extra_image,
        jl.status,
        jl.created_at,
        s.id,
        s.style_title,
        f.fabric_id,
        f.design_no
    ');
        $this->db->from('tb_jacket_lapels jl');
        $this->db->join('tb_style s', 'jl.style_id = s.id', 'left');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');

        $this->db->order_by('jl.id', 'DESC');

        $query = $this->db->get();
        return $query->result_array();
    }


    // public function getStylesByFabricId($fabric_id) {
    //     $this->db->select('id, style_title');
    //     $this->db->from('tb_style'); // your table name
    //     $this->db->where('fabric_id', $fabric_id);
    //     return $this->db->get()->result();
    // }


    public function getStylesByFabricId($fabric_id)
    {
        return $this->db
            ->select('id, style_title')
            ->from('tb_style')
            ->where('fabric_id', $fabric_id)
            ->get()
            ->result();
    }

    public function insertJacketLapels($data)
    {
        return $this->db->insert('tb_jacket_lapels', $data);
    }

    public function JacketLapelsStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_jacket_lapels')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_jacket_lapels', $data);
        return $this->db->affected_rows();
    }



    public function UpdateJacketStyle($id)
    {
        $this->db->select('*');
        $this->db->from('tb_jacket_lapels');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }

    public function updateJacketLapels($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('tb_jacket_lapels', $data);
    }







    //Lapel Width

    public function getAllLapelWidth()
    {
        $this->db->select('
        lw.id AS lapel_width_id,
        lw.lapel_width_title,
        lw.image,
        lw.extra_image,
        lw.status,
        lw.created_at,
        jl.id,
        jl.jacket_lapels_title,
        s.id,
        s.style_title,
        f.fabric_id,
        f.design_no
    ');
        $this->db->from('tb_lapel_width lw');
        $this->db->join('tb_jacket_lapels jl', 'lw.lapel_id = jl.id', 'left');
        $this->db->join('tb_style s', 'jl.style_id = s.id', 'left');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');
        $this->db->order_by('lw.id', 'DESC');
        $query = $this->db->get();
        return $query->result_array();
    }



    public function insertWidthLapels($data)
    {
        return $this->db->insert('tb_lapel_width', $data);
    }

    public function getJacketLapelsByStyleId($style_id)
    {
        return $this->db
            ->select('id AS lapel_id, jacket_lapels_title')
            ->from('tb_jacket_lapels')
            ->where('style_id', $style_id)
            ->get()
            ->result();
    }



    public function LapelsWidthStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_lapel_width')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_lapel_width', $data);
        return $this->db->affected_rows();
    }


    public function UpdateLapelWidthStyle($id)
    {
        $this->db->select('*');
        $this->db->from('tb_lapel_width');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }

    public function updateLapelWidth($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('tb_lapel_width', $data); // ✅ Use your actual table name
    }



    //Jacket Lapels

    public function getAllPocketStyle()
    {
        $this->db->select('
        jl.id AS lapel_id,
        jl.pocket_style_name,
        jl.image,
        jl.extra_image,
        jl.status,
        jl.created_at,
        s.id,
        s.style_title,
        f.fabric_id,
        f.design_no
    ');
        $this->db->from('tb_pocket_style jl');
        $this->db->join('tb_style s', 'jl.style_id = s.id', 'left');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');

        $this->db->order_by('jl.id', 'DESC');

        $query = $this->db->get();
        return $query->result_array();
    }


    // public function getStylesByFabricId($fabric_id) {
    //     $this->db->select('id, style_title');
    //     $this->db->from('tb_style'); // your table name
    //     $this->db->where('fabric_id', $fabric_id);
    //     return $this->db->get()->result();
    // }


    // public function getStylesByFabricId($fabric_id) {
    //     return $this->db
    //         ->select('id, style_title')
    //         ->from('tb_style')
    //         ->where('fabric_id', $fabric_id)
    //         ->get()
    //         ->result();
    // }

    public function insertPocketStyle($data)
    {
        return $this->db->insert('tb_pocket_style', $data);
    }

    public function pocketStyleStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_pocket_style')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_pocket_style', $data);
        return $this->db->affected_rows();
    }

    public function UpdatePocketStyle($id)
    {
        $this->db->select('*');
        $this->db->from('tb_pocket_style');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }

    public function updatePocketStyles($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('tb_pocket_style', $data);
    }




    //Back Style

    public function getAllBackStyle()
    {
        $this->db->select('
        jl.id AS lapel_id,
        jl.back_style_name,
        jl.image,
        jl.extra_image,
        jl.status,
        jl.created_at,
        s.id,
        s.style_title,
        f.fabric_id,
        f.design_no
    ');
        $this->db->from('tb_back_style jl');
        $this->db->join('tb_style s', 'jl.style_id = s.id', 'left');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');

        $this->db->order_by('jl.id', 'DESC');

        $query = $this->db->get();
        return $query->result_array();
    }


    // public function getStylesByFabricId($fabric_id) {
    //     $this->db->select('id, style_title');
    //     $this->db->from('tb_style'); // your table name
    //     $this->db->where('fabric_id', $fabric_id);
    //     return $this->db->get()->result();
    // }


    // public function getStylesByFabricId($fabric_id) {
    //     return $this->db
    //         ->select('id, style_title')
    //         ->from('tb_style')
    //         ->where('fabric_id', $fabric_id)
    //         ->get()
    //         ->result();
    // }

    public function insertBackStyle($data)
    {
        return $this->db->insert('tb_back_style', $data);
    }

    public function BackStyleStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_back_style')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_back_style', $data);
        return $this->db->affected_rows();
    }



    public function UpdateBackStyle($id)
    {
        $this->db->select('*');
        $this->db->from('tb_back_style');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }

    public function updateBackStyles($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('tb_back_style', $data);
    }


    //Blazer Initials

    public function getAllBlazerInitials()
    {
        return $this->db->order_by('id ', 'DESC')->get('tb_blazer_initials')->result_array();
    }

    public function insertBlazerInitials($data)
    {
        return $this->db->insert('tb_blazer_initials', $data); // ✅ use your correct table name
    }

    public function BlazerInitialsStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_blazer_initials')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_blazer_initials', $data);
        return $this->db->affected_rows();
    }


    public function UpdateBlazerInitials($id)
    {
        $this->db->select('*');
        $this->db->from('tb_blazer_initials');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }

    public function updateBlazerInitialss($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('tb_blazer_initials', $data);
    }





    //Sleeve Button

    public function getAllSleeveButton()
    {
        $this->db->select('
        jl.id AS lapel_id,
        jl.sleeve_button_name,
        jl.image,
        jl.extra_image,
        jl.status,
        jl.created_at,
        s.id,
        s.style_title,
        f.fabric_id,
        f.design_no
    ');
        $this->db->from('tb_sleeve_button jl');
        $this->db->join('tb_style s', 'jl.style_id = s.id', 'left');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');

        $this->db->order_by('jl.id', 'DESC');

        $query = $this->db->get();
        return $query->result_array();
    }



    public function insertSleeveButton($data)
    {
        return $this->db->insert('tb_sleeve_button', $data); // ✅ use your correct table name
    }

    public function sleeveButtonStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_sleeve_button')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_sleeve_button', $data);
        return $this->db->affected_rows();
    }


    public function UpdateSleeveButton($id)
    {
        $this->db->select('*');
        $this->db->from('tb_sleeve_button');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }


    public function updatesleeveButtons($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('tb_sleeve_button', $data);
    }

    //Button Hole

    public function getAllButtonHole()
    {
        $this->db->select('
        jl.id AS lapel_id,
        jl.button_hole_name,
        jl.image,
        jl.extra_image,
        jl.status,
        jl.created_at,
        s.id,
        s.style_title,
        f.fabric_id,
        f.design_no
    ');
        $this->db->from('tb_button_hole jl');
        $this->db->join('tb_style s', 'jl.style_id = s.id', 'left');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');

        $this->db->order_by('jl.id', 'DESC');

        $query = $this->db->get();
        return $query->result_array();
    }





    public function insertButtonHole($data)
    {
        return $this->db->insert('tb_button_hole', $data); // ✅ use your correct table name
    }

    public function buttonHoleStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_button_hole')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_button_hole', $data);
        return $this->db->affected_rows();
    }


    public function UpdateButtonHole($id)
    {
        $this->db->select('*');
        $this->db->from('tb_button_hole');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }


    public function updateButtonHoles($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('tb_button_hole', $data);
    }




    // //Button placement

    public function getAllButtonPlacement()
    {
        $this->db->select('
        jl.id AS lapel_id,
        jl.button_placement_name,
        jl.image,
        jl.extra_image,
        jl.status,
        jl.created_at,
        s.id,
        s.style_title,
        f.fabric_id,
        f.design_no
    ');
        $this->db->from('tb_button_placement jl');
        $this->db->join('tb_style s', 'jl.style_id = s.id', 'left');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');

        $this->db->order_by('jl.id', 'DESC');

        $query = $this->db->get();
        return $query->result_array();
    }


    public function insertButtonPlacement($data)
    {
        return $this->db->insert('tb_button_placement', $data); // ✅ use your correct table name
    }


    public function buttonPlacementStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_button_placement')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_button_placement', $data);
        return $this->db->affected_rows();
    }

    public function UpdateButtonPlacement($id)
    {
        $this->db->select('*');
        $this->db->from('tb_button_placement');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }


    public function updateButtonPlacements($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('tb_button_placement', $data);
    }


    // //Breast Pocket

    public function getAllBreastPocket()
    {
        $this->db->select('
        jl.id AS lapel_id,
        jl.breast_pocket_name,
        jl.image,
        jl.extra_image,
        jl.status,
        jl.created_at,
        s.id,
        s.style_title,
        f.fabric_id,
        f.design_no
    ');
        $this->db->from('tb_breast_pocket jl');
        $this->db->join('tb_style s', 'jl.style_id = s.id', 'left');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');

        $this->db->order_by('jl.id', 'DESC');

        $query = $this->db->get();
        return $query->result_array();
    }


    public function insertBreastPocket($data)
    {
        return $this->db->insert('tb_breast_pocket', $data); // ✅ use your correct table name
    }


    public function breastPocketStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_breast_pocket')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_breast_pocket', $data);
        return $this->db->affected_rows();
    }

    public function UpdateBreastPocket($id)
    {
        $this->db->select('*');
        $this->db->from('tb_breast_pocket');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }


    public function updateBreastPockets($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('tb_breast_pocket', $data);
    }




    //sleeves


    public function getAllFabricAgainstSleeve($fabric_id = "")
    {
        $this->db->select('f.fabric_id, f.design_no, s.*');
        $this->db->from('tb_sleeves s');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');

        if (!empty($fabric_id)) {
            $this->db->where('f.fabric_id', $fabric_id);
        }

        $this->db->order_by('s.id', 'DESC'); // Order styles by ID descending

        $query = $this->db->get();
        return $query->result_array();
    }



    // public function getAllFabricAgainstStyle()
    // {
    //     return $this->db->order_by('id ', 'DESC')->get('tb_style')->result_array();
    // }


    // public function Addstyle($fabric_id)
    // {
    //     return $this->db->get_where('tb_fabric', ['fabric_id' => $fabric_id])->row_array();
    // }


    public function insertSleeve($data)
    {
        return $this->db->insert('tb_sleeves', $data);
    }

    public function sleeveStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_sleeves')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_sleeves', $data);
        return $this->db->affected_rows();
    }


    public function UpdateSleeve($id)
    {
        $this->db->select('*');
        $this->db->from('tb_sleeves');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }

    public function updateSleeveFabricWise($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('tb_sleeves', $data);
    }


    //Buttons


    public function getAllButtons()
    {
        return $this->db->order_by('id ', 'DESC')->get('tb_button')->result_array();
    }


    public function insertButton($data)
    {
        return $this->db->insert('tb_button', $data); // Change `tb_button` to your actual table name
    }



    public function buttonStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_button')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_button', $data);
        return $this->db->affected_rows();
    }


    public function UpdateButton($id)
    {
        $this->db->select('*');
        $this->db->from('tb_button');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }

    public function updateButtons($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('tb_button', $data);
    }

    //Elbow Patches


    public function getAllElbowPatches()
    {
        return $this->db->order_by('id ', 'DESC')->get('tb_elbow_patches')->result_array();
    }


    public function insertElbowPatches($data)
    {
        return $this->db->insert('tb_elbow_patches', $data); // Change `tb_button` to your actual table name
    }



    public function elbowPatchesStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_elbow_patches')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_elbow_patches', $data);
        return $this->db->affected_rows();
    }


    public function UpdateElbowPatches($id)
    {
        $this->db->select('*');
        $this->db->from('tb_elbow_patches');
        $this->db->where('id', $id);
        $this->db->where('status', 'Active');
        $query = $this->db->get();

        return $query->row_array(); // ← returns object
    }

    public function updateElbowPatchess($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('tb_elbow_patches', $data);
    }


    //Dashbioard

    public function getFabricCount()
    {
        $query = $this->db->get('tb_fabric');
        return $query->result_array();
    }
    public function getButtonCount()
    {
        $query = $this->db->get('tb_button');
        return $query->result_array();
    }


    //Folded Pant


    public function getAllFoldedPatches($fabric_id = "")
    {
        $this->db->select('f.fabric_id, f.design_no, s.*');
        $this->db->from('tb_folded_pants s');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');

        if (!empty($fabric_id)) {
            $this->db->where('f.fabric_id', $fabric_id);
        }

        $this->db->order_by('s.folded_pant_id', 'DESC'); // Order styles by ID descending

        $query = $this->db->get();
        return $query->result_array();
    }

    // public function getAllFabricName()
    // {
    //     $this->db->select('*');
    //     $this->db->from('tb_fabric');
    //     $this->db->order_by('fabric_id', 'DESC');
    //     $query = $this->db->get();
    //     return $query->result();
    // }


    // public function getAllFabric()
    // {
    //     $this->db->select('*');
    //     $this->db->from('tb_fabric');
    //     $this->db->order_by('fabric_id', 'DESC');
    //     $query = $this->db->get();
    //     return $query->result();
    // }


    // public function getAllFabricAgainstStyle()
    // {
    //     return $this->db->order_by('id ', 'DESC')->get('tb_style')->result_array();
    // }


    // public function Addstyle($fabric_id)
    // {
    //     return $this->db->get_where('tb_fabric', ['fabric_id' => $fabric_id])->row_array();
    // }


    public function insertFoldedPant($data)
    {
        return $this->db->insert('tb_folded_pants', $data);
    }

    public function foldedPantStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_folded_pants')->where('folded_pant_id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('folded_pant_id', $id);
        $this->db->update('tb_folded_pants', $data);
        return $this->db->affected_rows();
    }


    public function UpdateFoldedPant($id)
    {
        $this->db->select('f.fabric_id, f.design_no, s.*');
        $this->db->from('tb_folded_pants s');
        $this->db->join('tb_fabric f', 's.fabric_id = f.fabric_id', 'left');
        $this->db->where('s.folded_pant_id', $id);
        $query = $this->db->get();

        return $query->row_array(); // return a single record as array
    }


    public function updateFoldedPants($id, $data)
    {
        $this->db->where('folded_pant_id', $id);
        return $this->db->update('tb_folded_pants', $data);
    }


    public function getAllStyleName()
    {
        $query = $this->db->query("
        SELECT 
           style_title
        FROM tb_style 
        WHERE status = 'Active' 
        GROUP BY style_title
        ORDER BY style_title ASC
    ");
        return $query->result_array();
    }

    public function getAllJacketLapelsByName()
    {
        $query = $this->db->query("
            SELECT 
            jacket_lapels_title
            FROM tb_jacket_lapels 
            WHERE status = 'Active' 
            GROUP BY jacket_lapels_title
            ORDER BY jacket_lapels_title ASC
        ");
        return $query->result_array();
    }

    public function getAllLapelWidthsByName()
    {
        $query = $this->db->query("
            SELECT 
            lapel_width_title
            FROM tb_lapel_width 
            WHERE status = 'Active' 
            GROUP BY lapel_width_title
            ORDER BY lapel_width_title ASC
        ");
        return $query->result_array();
    }

    public function getAllColorsByName()
    {
        $query = $this->db->query("
            SELECT 
            color_thread
            FROM tb_blazer_initials 
            WHERE status = 'Active' 
            GROUP BY color_thread
            ORDER BY color_thread ASC
        ");
        return $query->result_array();
    }

    public function getAllLapelColors()
    {
        $query = $this->db->query("
            SELECT 
            *
            FROM tb_lapel_color 
            WHERE status = 'Active'
            ORDER BY id DESC
        ");
        return $query->result_array();
    }

    public function saveLapelColor($data, $lapel_id = NULL)
    {
        if ($lapel_id) {
            $this->db->where('id', $lapel_id)->update('tb_lapel_color', $data);
        } else {
            $this->db->insert('tb_lapel_color', $data);
        }

        return $this->db->insert_id();
    }

    public function editLapelColor($id)
    {
        $this->db->select('*');
        $this->db->from('tb_lapel_color');
        return $this->db->where(['id' => $id])->get()->row();
    }

    public function lapelColorStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tb_lapel_color')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tb_lapel_color', $data);
        return $this->db->affected_rows();
    }

    public function getAllLinings()
    {
        $this->db->select('*');
        $this->db->from('tbl_lining');
        return $this->db->get()->result_array();
    }

    public function liningStatusUpdate($id)
    {
        $currentStatus = $this->db->select('status')->from('tbl_lining')->where('id', $id)->get()->row()->status;
        $newStatus = ($currentStatus == 'Active') ? 'InActive' : 'Active';
        $data = array(
            'status' => $newStatus,
            // 'added_by' => $this->session->userdata('id')
        );
        $this->db->where('id', $id);
        $this->db->update('tbl_lining', $data);
        return $this->db->affected_rows();
    }

    public function saveLining($data, $lining_id = NULL)
    {
        if ($lining_id) {
            $this->db->where('id', $lining_id)->update('tbl_lining', $data);
        } else {
            $this->db->insert('tbl_lining', $data);
        }

        return $this->db->insert_id();
    }

    public function editLining($id)
    {
        $this->db->select('*');
        $this->db->from('tbl_lining');
        return $this->db->where(['id' => $id])->get()->row();
    }

    //  public function getAllOrders()
    // {

    //     $query = $this->db->query("SELECT * FROM tbl_orders WHERE order_status='pending'  Order BY id  ASC");
    //     return $query->result_array();
    // }

    public function getAllOrders()
{
    $this->db->select('tbl_orders.*, tb_login.mobile, tb_login.email'); // choose fields you need
    $this->db->from('tbl_orders');
    $this->db->join('tb_login', 'tb_login.login_id = tbl_orders.user_id', 'left'); 
    $this->db->where('tbl_orders.order_status', 'pending');
    $this->db->order_by('tbl_orders.id', 'DESC');
    $query = $this->db->get();
    return $query->result_array();
}

    public function getAllDispatchedOrders()
{
    $this->db->select('tbl_orders.*, tb_login.mobile, tb_login.email'); // choose fields you need
    $this->db->from('tbl_orders');
    $this->db->join('tb_login', 'tb_login.login_id = tbl_orders.user_id', 'left'); 
    $this->db->where('tbl_orders.order_status', 'dispatched');
    $this->db->order_by('tbl_orders.id', 'DESC');
    $query = $this->db->get();
    return $query->result_array();
}
public function updateOrderStatus($id, $status)
{
    $this->db->where('id', $id);
    $this->db->update('tbl_orders', ['order_status' => $status]);
    return $this->db->affected_rows() > 0;
}

public function DiapatchedOrderStatusUpdate($id, $status)
{
    $this->db->where('id', $id);
    $this->db->update('tbl_orders', ['order_status' => $status]);
    return $this->db->affected_rows() > 0;
}

public function getAllCompletdOrders()
{
    $this->db->select('tbl_orders.*, tb_login.mobile, tb_login.email'); // choose fields you need
    $this->db->from('tbl_orders');
    $this->db->join('tb_login', 'tb_login.login_id = tbl_orders.user_id', 'left'); 
    $this->db->where('tbl_orders.order_status', 'complete');
    $this->db->order_by('tbl_orders.id', 'DESC');
    $query = $this->db->get();
    return $query->result_array();
}

public function getAllCancelledOrders()
{
    $this->db->select('tbl_orders.*, tb_login.mobile, tb_login.email'); // choose fields you need
    $this->db->from('tbl_orders');
    $this->db->join('tb_login', 'tb_login.login_id = tbl_orders.user_id', 'left'); 
    $this->db->where('tbl_orders.order_status', 'cancelled');
    $this->db->order_by('tbl_orders.id', 'DESC');
    $query = $this->db->get();
    return $query->result_array();
}

public function updatePaymentStatus($id, $status)
{
    $this->db->where('id', $id);
    return $this->db->update('tbl_orders', ['payment_status' => $status]);
}

public function getAllOrderDetails($order_id)
{
    if (empty($order_id)) {
        return false;
    }

    $this->db->select("
       *
    ");
    $this->db->from("tbl_orders o");
    $this->db->where("o.order_id", $order_id);
    $query = $this->db->get();

    if ($query->num_rows() > 0) {
        return $query->row_array(); // return single row as array
    } else {
        return false;
    }
}


}
