<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Welcome extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('UserModel');
		$this->load->helper('download');
	}

	public function index()
	{
		$this->load->view('index');
	}

	public function customSuits()
	{
		$this->load->view('custom-suits');
	}


	public function customSuitsDetail()
	{
		$data['customerDetails'] = $this->UserModel->getCustomerDetails();
		$data['style'] = $this->UserModel->getStyle();
		$data['pocketStyle'] = $this->UserModel->getPocketStyle();
		$data['jacketLapels'] = $this->UserModel->getjacketLapels();
		$data['lapelWidth'] = $this->UserModel->getlapelWidth();
		$data['threadColor'] = $this->UserModel->getThreadColor();
		$data['backStyle'] = $this->UserModel->getBackStyle();
		$data['breastPocket'] = $this->UserModel->getBreastPocket();
		$data['elbowPatches'] = $this->UserModel->getElbowPatches();
		$data['fullLinings'] =  $this->UserModel->getLinings('Full lining');
		$data['HalfLinings'] =  $this->UserModel->getLinings('Half lining');
		$data['UnlinedLinings'] =  $this->UserModel->getLinings('Unlined');

		// print_r($data['backStyle']);die();
		$this->load->view('custom-suits-detail', $data);
	}

	public function aboutUs()
	{
		$this->load->view('about');
	}

	public function contactUs()
	{
		$this->load->view('contact');
	}

	public function login()
	{
		$this->load->view('login');
	}

	public function get_button_data()
	{
		$value = $this->input->post('value', true);

		if (!empty($value)) {
			$this->db->group_by('button_color');
			$query = $this->db->get('tb_button');
			$result = $query->result_array();

			if (!empty($result)) {
				echo json_encode(['status' => 'success', 'data' => $result]);
			} else {
				echo json_encode(['status' => 'error', 'message' => 'No records found']);
			}
		} else {
			echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
		}
	}

	public function userLogin()
	{
		if (isset($_POST) && !empty($_POST)) {
			$this->form_validation->set_rules('email', 'Email', 'required|valid_email');
			$this->form_validation->set_rules('password', 'Password', 'required');
			if ($this->form_validation->run() == FALSE) {
				$this->load->view('login');
			} else {
				$email = $this->input->post('email');
				$password = $this->input->post('password');
				$condition = array(
					'email'    => $email,
					'password' => md5($password),
					'status'   => 'Active',
				);
				// print_r($email,$password);die();
				$userDetails = $this->UserModel->login($condition);
				if (!empty($userDetails)) {
					$this->session->set_userdata('login_id', $userDetails->login_id);
					$this->session->set_userdata('email', $userDetails->email);
					$this->session->set_userdata('mobile', $userDetails->mobile);
					$this->session->set_userdata('first_name', $userDetails->f_name);
					$this->session->set_userdata('last_name', $userDetails->l_name);
					$this->session->set_flashdata('user_login_success', 'Logged in Successfully');
					redirect(base_url('dashboard'));
				} else {
					$condition = array(
						'email' => $email,
						'password' => md5($password),
						'status' => 'active',
					);
					$subAdmin = $this->UserModel->login($condition);
					if (!empty($subAdmin)) {
						$this->session->set_userdata('login_id', $subAdmin->login_id);
						$this->session->set_userdata('email', $subAdmin->email);
						$this->session->set_userdata('mobile', $subAdmin->mobile);
						$this->session->set_userdata('first_name', $userDetails->f_name);
						$this->session->set_userdata('last_name', $userDetails->l_name);
						$this->session->set_flashdata('user_login_success', 'Logged in Successfully');
						redirect(base_url('dashboard'));
					} else {
						$this->session->set_flashdata('user_login_error', 'Invalid Credentials');
						redirect(base_url('login'));
					}
				}
			}
		} else {
			if (!empty($this->session->userdata('login_id')) && ($this->session->userdata('role') == 'admin' || $this->session->userdata('role') == 'center')) {
				redirect(base_url('dashboard'));
			} else {
				$this->load->view('login');
			}
		}
	}


	public function logout()
	{
		$this->session->sess_destroy();
		redirect('login');
	}

	public function profile()
	{
		$this->load->view('profile');
	}

	public function myOrders()
	{
		$this->load->view('my-orders');
	}

	public function updateUserProfile()
	{
		$user_id = $this->session->userdata('login_id');
		$first_name = $this->input->post('first_name', true);
		$last_name = $this->input->post('last_name', true);
		$email = $this->input->post('email', true);
		$mobile = $this->input->post('mobile', true);

		$data = array(
			'f_name' => $first_name,
			'l_name' => $last_name,
			'email' => $email,
			'mobile' => $mobile,
		);
		$res = $this->UserModel->updateUserProfile($user_id, $data);
		// print_r($this->db->last_query());
		// die;
		if ($res) {
			$this->session->set_userdata('email', $email);
			$this->session->set_userdata('mobile', $mobile);
			$this->session->set_userdata('first_name', $first_name);
			$this->session->set_userdata('last_name', $last_name);
			$this->session->set_flashdata('success', 'Details updated successfully');
		} else {
			$this->session->set_flashdata('error', 'Unable to update details');
		}
		redirect(base_url('dashboard'));
	}



	// public function logout() {
	//     $this->session->sess_destroy();
	//     redirect('login');
	// }
	public function cart()
	{
		if ($this->input->get('delete') !== null && $this->input->get('delete') !== '') {
			$deleteKey = $this->input->get('delete');

			// Decode as an array
			$cart = json_decode($_COOKIE['customSuitArray'], true);

			

			if (isset($cart[$deleteKey])) {
				unset($cart[$deleteKey]);

				// Save updated cart back to cookie
				setcookie('customSuitArray', json_encode($cart), time() + 86400, '/');
			}
		}
		$this->load->view('cart');
	}
public function checkout()
{
    if ($this->input->server('REQUEST_METHOD') === 'POST') {

        $shipping_data = [
            'customer_name'    => $this->input->post('customer_name', true),
            'customer_email'   => $this->input->post('customer_email', true),
            'customer_mobile'  => $this->input->post('customer_mobile', true),
            'customer_pincode' => $this->input->post('customer_pincode', true),
            'customer_address' => $this->input->post('customer_address', true),
            'customer_city'    => $this->input->post('customer_city', true),
            'customer_state'   => $this->input->post('customer_state', true),
            'customer_country' => $this->input->post('customer_country', true),
        ];

        // Store in session
        $this->session->set_userdata('shipping_session', $shipping_data);

        // Redirect to proceed-to-payment
        redirect('proceed-to-payment');
    } else {
        $this->load->view('checkout');
    }
}

	// public function forgotPass()
	// {
	//  $this->load->view('forgot-pass');
	// }
	public function forgotPass()
	{
		$this->load->model('UserModel');
		$this->load->library('email');
		if ($_SERVER['REQUEST_METHOD'] === 'POST') {
			$email = $this->input->post('email', true);
			$user = $this->UserModel->get_user_by_email($email);
			if ($user) {
				// Generate secure token
				$token = bin2hex(random_bytes(32));
				// Save token to DB
				$this->UserModel->save_reset_token($email, $token);
				// Reset password link
				$reset_link = base_url('reset-password/' . $token);
				// :white_check_mark: Gmail SMTP Config
				$config = array(
					'protocol'    => 'smtp',
					'smtp_host'   => 'smtp.gmail.com',
					'smtp_port'   => 587,
					'smtp_user'   => 'wowinfotechmobiles@gmail.com',
					'smtp_pass'   => 'brgx qqzu sjhw pmbj', // App Password
					'smtp_crypto' => 'tls',
					'mailtype'    => 'html',
					'charset'     => 'utf-8',
					'newline'     => "\r\n"
				);
				// Initialize email
				$this->email->initialize($config);
				$this->email->from('wowinfotechmobiles@gmail.com', 'Your Website');
				$this->email->to($email);
				$this->email->subject('Password Reset Request');
				$this->email->message("
                <p>Dear User,</p>
                <p>You requested a password reset. Click the link below:</p>
                <p><a href='$reset_link'>$reset_link</a></p>
                <p>If you didn't request this, please ignore the email.</p>
            ");
				// Send the email
				if ($this->email->send()) {
					$this->session->set_flashdata('success', 'Password reset link sent to your email.');
				} else {
					$this->session->set_flashdata('error', 'Failed to send email. Please try again later.');
				}
				redirect('forgot-password');
			} else {
				$this->session->set_flashdata('error', 'Email address not found.');
				redirect('forgot-password');
			}
		} else {
			$this->load->view('forgot-pass');
		}
	}
	public function resetPassword($token)
	{
		$this->load->model('UserModel');
		$user = $this->UserModel->get_user_by_token($token);
		if (!$user) {
			$this->session->set_flashdata('error', 'Invalid or expired reset token.');
			redirect('login');
		}
		if ($_SERVER['REQUEST_METHOD'] === 'POST') {
			$pass = $this->input->post('password');
			$confirm = $this->input->post('confirm_password');
			if ($pass === $confirm) {
				$hashed = md5($pass); // :closed_lock_with_key: or use password_hash() for better security
				$this->UserModel->update_password_by_token($token, $hashed);
				$this->session->set_flashdata('success', 'Password updated. Please login.');
				redirect('login');
			} else {
				$this->session->set_flashdata('error', 'Passwords do not match.');
			}
		}
		$this->load->view('reset-password');
	}
	public function register()
	{
		if ($_SERVER['REQUEST_METHOD'] === 'POST') {
			$this->load->library('form_validation');
			$this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[tb_login.email]');
			$this->form_validation->set_rules('mobile', 'Mobile', 'required|min_length[10]');
			$this->form_validation->set_rules('password', 'Password', 'required|min_length[6]');
			$this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|matches[password]');
			if ($this->form_validation->run() === FALSE) {
				$this->session->set_flashdata('error', validation_errors());
				redirect('register'); // reload with error
			} else {
				$data = [
					'email'    => $this->input->post('email', true),
					'mobile'   => $this->input->post('mobile', true),
					'password' => md5($this->input->post('password'))
				];
				// print_r($data);die();
				$this->load->model('UserModel');
				$this->UserModel->insert_user($data);
				$this->session->set_flashdata('success', 'Registration successful. Please login.');
				redirect('login'); // goes to login page
			}
		} else {
			$this->load->view('register');
		}
	}

public function proceed_to_payment()
{
    $shipping = $this->session->userdata('shipping_session');
//   $user_id  = $this->session->userdata('login_id'); // or last_session_id if you saved like that

    if (!$shipping) {
        redirect('checkout'); // No shipping session, go back
    }

    // Generate random order id (10000+)
    $order_id = rand(10000, 99999);

    // Prepare order data
    $orderData = [
        'order_id'            => $order_id, // random order id
        // 'user_id'             => $user_id, // user id from session
        'order_address_details' => json_encode($shipping),
        'order_details'       => isset($_COOKIE['customSuitArray']) ? $_COOKIE['customSuitArray'] : '',
        'created_date'        => date('Y-m-d H:i:s')
    ];

	//  print_r($orderData);die();
    // Insert into tbl_orders
    $this->db->insert('tbl_orders', $orderData);

	// print_r($this->db->last_query());die();
    // Save order_id in session
    $this->session->set_userdata('order_id', $order_id);

    // Clear cart if needed
    // $this->session->unset_userdata('cart');

    // Redirect to thank you page
    redirect('thank-you?order_id=' . $order_id);
}



	// public function thankYou()
	// {
	//  $this->load->view('thank-you');
	// }

	public function thankYou()
{
    $order_id = $this->input->get('order_id'); // from URL
    $this->load->view('thank-you', ['order_id' => $order_id]);
}

}
