<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once FCPATH . 'vendor/autoload.php';

use Aws\S3\S3Client;

class AdminController extends CI_Controller
{
    //Load Files  
    public function __construct()
    {
        parent::__construct();
        $this->load->model('AdminModel');
        $this->load->helper('download');

        $this->S3_BUCKET = S3_BUCKET;
        $this->S3_ACCESS = S3_ACCESS;
        $this->S3_SECRET = S3_SECRET;
        $this->s3 = new Aws\S3\S3Client([
            'version'     => 'latest',
            'region'      => 'us-east-1', // change to your bucket's region
            'credentials' => [
                'key'    => S3_ACCESS,
                'secret' => S3_SECRET
            ]
        ]);
    }

    //Login
    public function index()
    {
        if (isset($_POST) && !empty($_POST)) {
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
            $this->form_validation->set_rules('password', 'Password', 'required');
            if ($this->form_validation->run() == FALSE) {
                $this->load->view('admin/login');
            } else {
                $email = $this->input->post('email');
                $password = $this->input->post('password');
                $condition = array(
                    'email'    => $email,
                    'password' => md5($password),
                    'status'   => 'active',
                    'role'     => 'admin'
                );
                $userDetails = $this->AdminModel->login($condition);
                if (!empty($userDetails)) {
                    $this->session->set_userdata('id', $userDetails->id);
                    $this->session->set_userdata('first_name', $userDetails->first_name);
                    $this->session->set_userdata('last_name', $userDetails->last_name);
                    $this->session->set_userdata('email', $userDetails->email);
                    $this->session->set_userdata('mobile', $userDetails->mobile);
                    $this->session->set_userdata('profile_image', $userDetails->profile_image);
                    $this->session->set_userdata('role', $userDetails->role);
                    $this->session->set_flashdata('admin_login_success', 'Logged in Successfully');
                    redirect(base_url('admin/dashboard'));
                } else {
                    $condition = array(
                        'email' => $email,
                        'password' => md5($password),
                        'status' => 'active',
                    );
                    $subAdmin = $this->AdminModel->login($condition);
                    if (!empty($subAdmin)) {

                        $this->session->set_userdata('id', $subAdmin->id);
                        $this->session->set_userdata('first_name', $subAdmin->first_name);
                        $this->session->set_userdata('last_name', $subAdmin->last_name);
                        $this->session->set_userdata('email', $subAdmin->email);
                        $this->session->set_userdata('mobile', $subAdmin->mobile);
                        $this->session->set_userdata('profile_image', $subAdmin->profile_image);
                        $this->session->set_userdata('role', $subAdmin->role);
                        $this->session->set_flashdata('admin_login_success', 'Logged in Successfully');
                        redirect(base_url('admin/dashboard'));
                    } else {
                        $this->session->set_flashdata('admin_login_error', 'Invalid Credentials');
                        redirect(base_url('admin'));
                    }
                }
            }
        } else {
            if (!empty($this->session->userdata('id')) && ($this->session->userdata('role') == 'admin' || $this->session->userdata('role') == 'center')) {
                redirect(base_url('admin/dashboard'));
            } else {
                $this->load->view('admin/login');
            }
        }
    }

    //Logout
    public function logout()
    {
        $this->session->sess_destroy();
        redirect(base_url('admin/login'));
    }

    //Display Dashboard
    public function dashboard()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricCount'] = $this->AdminModel->getFabricCount();
            $data['buttonCount'] = $this->AdminModel->getButtonCount();
            $data['content'] = array();
            $data['SEO'] = array('pageTitle' => 'Dashboard');
            $data['page'] = 'dashboard';
            // print_r($data);die();
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('login'));
        }
    }

    //Fabric Master
    public function fabric()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabric'] = $this->AdminModel->getAllFabrics();
            // print_r($data['fabric']);die();
            $data['content'] = array();
            $data['SEO'] = array('pageTitle' => 'Fabric');
            $data['page'] = 'fabric';
            // print_r($data);die();
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin/fabric'));
        }
    }


    public function addFabric()
    {
        if (!empty($this->session->userdata('id'))) {

            $data['SEO'] = array('pageTitle' => 'Add Fabric');
            $data['page'] = 'add-fabric';
            $data['content'] = array();
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    // public function saveFabric()
    // {
    //     if (!empty($this->session->userdata('id'))) {
    //         $post = $this->input->post();

    //         // Initialize image name
    //         $image_name = '';

    //         // Check if an image is uploaded
    //         if (!empty($_FILES['fabric_image']['name'])) {
    //             // Convert fabric name (design_no) to lowercase hyphen format
    //             $fabric_folder_name = strtolower(str_replace(' ', '-', $post['design_no']));
    //             $base_path = './uploads/fabric/' . $fabric_folder_name . '/';

    //             // Define subfolders
    //             $subfolders = ['front', 'back', 'interior', 'pant'];

    //             // Create base and subfolders
    //             foreach ($subfolders as $folder) {
    //                 $full_path = $base_path . $folder;
    //                 if (!is_dir($full_path)) {
    //                     mkdir($full_path, 0777, true);
    //                 }
    //             }

    //             // Upload image to 'front' folder by default
    //             $upload_path = './uploads/fabric/';
    //             $file_name =  preg_replace('/\s+/', '-', strtolower($_FILES['fabric_image']['name']));

    //             // Set config
    //             $config['upload_path']   = $upload_path;
    //             $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
    //             $config['max_size']      = 2048; // 2MB
    //             $config['file_name']     = $file_name;

    //             $this->load->library('upload', $config);
    //             $this->upload->initialize($config);

    //             // Upload file
    //             if ($this->upload->do_upload('fabric_image')) {
    //                 $uploadData = $this->upload->data();
    //                 $image_name = $uploadData['file_name']; // Save full relative path
    //             } else {
    //                 $this->session->set_flashdata('image_upload_error', $this->upload->display_errors());
    //                 redirect(base_url('admin/fabric'));
    //                 return;
    //             }
    //         }


    //         // Save to DB
    //         $fabricData = array(
    //             'design_no'   => $post['design_no'],
    //             'blend'       => $post['blend'],
    //             'price_inr'   => $post['price_inr'],
    //             'price_usd'   => $post['price_usd'],
    //             'price_gbp'   => $post['price_gbp'],
    //             'price_euro'  => $post['price_euro'],
    //             'washcare'    => $post['washcare'],
    //             'fabric_image'       => $image_name,
    //             'created_at'  => date('Y-m-d H:i:s')
    //         );

    //         // print_r($fabricData);die();

    //         $this->load->model('AdminModel');
    //         $this->AdminModel->insertFabric($fabricData);

    //         $this->session->set_flashdata('success', 'Fabric added successfully!');
    //         redirect('admin/fabric');
    //     } else {
    //         redirect('admin');
    //     }
    // }

    public function saveFabric()
    {
        if (empty($this->session->userdata('id'))) {
            redirect('admin');
            return;
        }

        $post = $this->input->post();
        $image_name = '';

        if (!empty($_FILES['fabric_image']['name'])) {
            // Prepare subfolders
            $subfolders = ['front', 'back', 'interior', 'pant'];
            $fabric_folder_name = strtolower(str_replace(' ', '-', $post['design_no']));
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['fabric_image']['name']));

            // 1️⃣ Create empty "folders" in S3
            foreach ($subfolders as $folder) {
                $folder_key = S3_TYPE . "/fabric/{$fabric_folder_name}/{$folder}/";
                try {
                    $this->s3->putObject([
                        'Bucket' => $this->S3_BUCKET,
                        'Key'    => $folder_key,
                        'Body'   => "", // empty body
                        'ACL'    => 'public-read'
                    ]);
                } catch (Aws\Exception\AwsException $e) {
                    $this->session->set_flashdata('image_upload_error', $e->getMessage());
                    redirect(base_url('admin/fabric'));
                    return;
                }
            }

            // 2️⃣ Upload the main image only once inside /fabric/
            $image_key = S3_TYPE . "/fabric/{$file_name}";
            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $image_key,
                    'SourceFile'  => $_FILES['fabric_image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['fabric_image']['tmp_name'])
                ]);
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('image_upload_error', $e->getMessage());
                redirect(base_url('admin/fabric'));
                return;
            }

            // Store image name
            $image_name = "fabric/{$file_name}";
        }

        // Save to DB
        $fabricData = [
            'design_no'     => $post['design_no'],
            'blend'         => $post['blend'],
            'price_inr'     => $post['price_inr'],
            'price_usd'     => $post['price_usd'],
            'price_gbp'     => $post['price_gbp'],
            'price_euro'    => $post['price_euro'],
            'washcare'      => $post['washcare'],
            'fabric_image'  => $file_name, // only path, no S3 URL
            'created_at'    => date('Y-m-d H:i:s')
        ];

        $this->load->model('AdminModel');
        $this->AdminModel->insertFabric($fabricData);

        $this->session->set_flashdata('success', 'Fabric added successfully!');
        redirect('admin/fabric');
    }


    public function FabricStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $fabric_id = $this->input->post('fabric_id');
            $result = $this->AdminModel->FabricStatusUpdate($fabric_id);
            if ($result) {
                $this->session->set_flashdata('success', 'fabric status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'fabric status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change fabric status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function editFabric($fabric_id = "")
    {
        if (!empty($this->session->userdata('id'))) {

            $UpdateFabric = $this->AdminModel->UpdateFabric($fabric_id);

            //  print_r($this->db->last_query());die();
            //  print_r($UpdateFabric);die();

            $data['SEO'] = array('pageTitle' => 'Update Fabric');
            $data['page'] = 'edit-fabric';
            $data['content'] = array(
                'UpdateFabric' => $UpdateFabric
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    // public function updateFabric()
    // {
    //     if (!empty($this->session->userdata('id'))) {

    //         $fabric_id    = $this->input->post('fabric_id');
    //         $design_no    = $this->input->post('design_no');
    //         $blend        = $this->input->post('blend');
    //         $price_inr    = $this->input->post('price_inr');
    //         $price_usd    = $this->input->post('price_usd');
    //         $price_gbp    = $this->input->post('price_gbp');
    //         $price_euro   = $this->input->post('price_euro');
    //         $washcare     = $this->input->post('washcare');
    //         $old_file     = $this->input->post('old_fabric_image');

    //         $image_name = '';

    //         if (!empty($_FILES['fabric_image']['name'])) {
    //             $config['upload_path'] = './uploads/fabric/';
    //             $config['allowed_types'] = '*';
    //             $config['max_size'] = 2048;
    //             $config['file_name'] = $_FILES['fabric_image']['name'];

    //             if (!is_dir($config['upload_path'])) {
    //                 mkdir($config['upload_path'], 0777, true);
    //             }

    //             $this->load->library('upload', $config);
    //             $this->upload->initialize($config);

    //             if ($this->upload->do_upload('fabric_image')) {
    //                 $uploadData = $this->upload->data();
    //                 $image_name = $uploadData['file_name'];
    //             } else {
    //                 $this->session->set_flashdata('image_upload_error', $this->upload->display_errors());
    //                 redirect(base_url('admin/fabric'));
    //                 return;
    //             }
    //         }

    //         $updateData = array(
    //             'design_no'     => $design_no,
    //             'blend'         => $blend,
    //             'price_inr'     => $price_inr,
    //             'price_usd'     => $price_usd,
    //             'price_gbp'     => $price_gbp,
    //             'price_euro'    => $price_euro,
    //             'washcare'      => $washcare,
    //             'fabric_image'  => $image_name,
    //             'updated_at'    => date('Y-m-d H:i:s')
    //         );

    //         $this->load->model('AdminModel');
    //         $result = $this->AdminModel->updatefabricDetails($updateData, $fabric_id);

    //         if ($result) {
    //             $this->session->set_flashdata('success', 'Fabric updated successfully.');
    //         } else {
    //             $this->session->set_flashdata('error', 'Failed to update fabric.');
    //         }

    //         redirect(base_url('admin/fabric'));
    //     } else {
    //         redirect(base_url('admin'));
    //     }
    // }

public function updateFabric()
{
    if (empty($this->session->userdata('id'))) {
        redirect(base_url('admin'));
        return;
    }

    $fabric_id  = $this->input->post('fabric_id');
    $design_no  = $this->input->post('design_no');
    $blend      = $this->input->post('blend');
    $price_inr  = $this->input->post('price_inr');
    $price_usd  = $this->input->post('price_usd');
    $price_gbp  = $this->input->post('price_gbp');
    $price_euro = $this->input->post('price_euro');
    $washcare   = $this->input->post('washcare');

    // Keep old image by default
    $image_name = $this->input->post('old_image'); // pass old image name via hidden input

    // Handle new file upload
    if (!empty($_FILES['fabric_image']['name'])) {

        $subfolders = ['front', 'back', 'interior', 'pant'];
        $fabric_folder_name = strtolower(str_replace(' ', '-', $design_no));
        $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['fabric_image']['name']));

        // 1️⃣ Create empty subfolders in S3
        foreach ($subfolders as $folder) {
            $folder_key = S3_TYPE . "/fabric/{$fabric_folder_name}/{$folder}/";
            try {
                $this->s3->putObject([
                    'Bucket' => $this->S3_BUCKET,
                    'Key'    => $folder_key,
                    'Body'   => "",
                    'ACL'    => 'public-read'
                ]);
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('image_upload_error', $e->getMessage());
                redirect(base_url('admin/fabric'));
                return;
            }
        }

        // 2️⃣ Delete old image if exists
        $old_file_key = S3_TYPE . "/fabric/{$fabric_folder_name}/front/{$file_name}";
        try {
            $this->s3->deleteObject([
                'Bucket' => $this->S3_BUCKET,
                'Key'    => $old_file_key
            ]);
        } catch (Aws\Exception\AwsException $e) {
            log_message('error', 'Failed to delete old S3 object: ' . $e->getMessage());
        }

        // 3️⃣ Upload new image
        $new_key = S3_TYPE . "/fabric/{$fabric_folder_name}/front/{$file_name}";
        try {
            $this->s3->putObject([
                'Bucket'      => $this->S3_BUCKET,
                'Key'         => $new_key,
                'SourceFile'  => $_FILES['fabric_image']['tmp_name'], // correct tmp_name
                'ACL'         => 'public-read',
                'ContentType' => mime_content_type($_FILES['fabric_image']['tmp_name'])
            ]);
        } catch (Aws\Exception\AwsException $e) {
            $this->session->set_flashdata('image_upload_error', $e->getMessage());
            redirect(base_url('admin/fabric'));
            return;
        }

        // Update image name for DB
        $image_name = "{$fabric_folder_name}/front/{$file_name}";
    }

    // Prepare update data
    $updateData = [
        'design_no'     => $design_no,
        'blend'         => $blend,
        'price_inr'     => $price_inr,
        'price_usd'     => $price_usd,
        'price_gbp'     => $price_gbp,
        'price_euro'    => $price_euro,
        'washcare'      => $washcare,
        'fabric_image'  => $image_name,
        'updated_at'    => date('Y-m-d H:i:s')
    ];

    // Save to DB
    $result = $this->AdminModel->updatefabricDetails($updateData, $fabric_id);

    if ($result) {
        $this->session->set_flashdata('success', 'Fabric updated successfully.');
    } else {
        $this->session->set_flashdata('error', 'Failed to update fabric.');
    }

    redirect(base_url('admin/fabric'));
}




    //style
    public function style($fabric_id = "")
    {
        // Get fabric_id from POST if available, otherwise keep URL parameter
        $fabric_id_post = $this->input->post('fabric_id');
        if (!empty($fabric_id_post)) {
            $fabric_id = $fabric_id_post;
        }

        // Check if admin is logged in
        if (!empty($this->session->userdata('id'))) {

            // Get styles filtered by fabric_id
            $style = $this->AdminModel->getAllFabricAgainstStyle($fabric_id);
            $data['content'] = array(
                'style' => $style,
                'fabric_id' => $fabric_id
            );

            $data['SEO'] = array('pageTitle' => 'Style');
            $data['page'] = 'style';

            // Load the admin template view
            $this->load->view('admin/template', $data);
        } else {
            // Redirect to login or base admin page
            redirect(base_url('admin'));
        }
    }



    public function addStyle($fabric_id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabricName();

            //  print_r $data['fabricName'];die();


            $data['SEO'] = array('pageTitle' => 'Add Style');
            $data['page'] = 'add-style';
            $data['style'] = $selected_fabric;  // instead of only ['fabric_id' => $fabric_id]
            $data['content'] = array();

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }



   public function saveStyle()
{
    if (empty($this->session->userdata('id'))) {
        redirect('admin');
        return;
    }

    $post = $this->input->post();
    $fabric_id   = $post['fabric_id'];
    $style_title = $post['style_title'];

    $this->load->model('AdminModel');

    // ✅ Get design_no from fabric
    $fabric = $this->db->select('design_no')
        ->from('tb_fabric')
        ->where('fabric_id', $fabric_id)
        ->get()
        ->row();

    if (!$fabric) {
        $this->session->set_flashdata('error', 'Fabric not found.');
        redirect('admin/style');
        return;
    }

    $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
    $subfolders = ['front', 'back', 'interior', 'pant'];

    // ✅ Handle style image upload to S3
    $style_image = '';
    if (!empty($_FILES['style_image']['name'])) {
        $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['style_image']['name']));



        // 2️⃣ Upload the main style image inside /front/
        $image_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name}";
        try {
            $this->s3->putObject([
                'Bucket'      => $this->S3_BUCKET,
                'Key'         => $image_key,
                'SourceFile'  => $_FILES['style_image']['tmp_name'],
                'ACL'         => 'public-read',
                'ContentType' => mime_content_type($_FILES['style_image']['tmp_name'])
            ]);
        } catch (Aws\Exception\AwsException $e) {
            $this->session->set_flashdata('image_upload_error', $e->getMessage());
            redirect(base_url('admin/style'));
            return;
        }

        // Save image path for DB
        $style_image = "{$design_no}/front/{$file_name}";
    }

    // ✅ Handle extra image upload to S3
    $extra_image = '';
    if (!empty($_FILES['extra_image']['name'])) {
        $file_name_extra = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
        $extra_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name_extra}";

        try {
            $this->s3->putObject([
                'Bucket'      => $this->S3_BUCKET,
                'Key'         => $extra_key,
                'SourceFile'  => $_FILES['extra_image']['tmp_name'],
                'ACL'         => 'public-read',
                'ContentType' => mime_content_type($_FILES['extra_image']['tmp_name'])
            ]);
        } catch (Aws\Exception\AwsException $e) {
            $this->session->set_flashdata('image_upload_error', $e->getMessage());
            redirect(base_url('admin/style'));
            return;
        }

        $extra_image = "{$design_no}/front/{$file_name_extra}";
    }

    // ✅ Save style to DB
    $styleData = [
        'fabric_id'    => $fabric_id,
        'style_title'  => $style_title,
        'style_image'  => $style_image,
        'extra_image'  => $extra_image,
        'created_at'   => date('Y-m-d H:i:s')
    ];

    $this->AdminModel->insertStyle($styleData);
    $this->session->set_flashdata('success', 'Style added successfully!');
    redirect('admin/style');
}



    public function styleStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('id');
            $result = $this->AdminModel->styleStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'style status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'style status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change style status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }


public function editStyle($id = "")
{
    if (empty($this->session->userdata('id'))) {
        redirect(base_url('admin'));
        return;
    }

    if ($this->input->method() === 'post') {
        // Collect form inputs
        $style_id   = $this->input->post('style_id');
        $fabric_id  = $this->input->post('fabric_id');
        $design_no  = $this->input->post('design_no');
        $style_title = $this->input->post('style_title');

        // Get old style details
        $style = $this->AdminModel->getStyleById($style_id);
        $style_image = !empty($style['style_image']) ? $style['style_image'] : '';
        $extra_image = !empty($style['extra_image']) ? $style['extra_image'] : '';

        // ✅ Handle style image upload
        if (!empty($_FILES['style_image']['name'])) {
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['style_image']['name']));
            $image_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $image_key,
                    'SourceFile'  => $_FILES['style_image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['style_image']['tmp_name'])
                ]);
                $style_image = "{$design_no}/front/{$file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('image_upload_error', $e->getMessage());
                redirect(base_url('admin/style'));
                return;
            }
        }

        // ✅ Handle extra image upload
        if (!empty($_FILES['extra_image']['name'])) {
            $file_name_extra = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
            $extra_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name_extra}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $extra_key,
                    'SourceFile'  => $_FILES['extra_image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['extra_image']['tmp_name'])
                ]);
                $extra_image = "{$design_no}/front/{$file_name_extra}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('image_upload_error', $e->getMessage());
                redirect(base_url('admin/style'));
                return;
            }
        }

        // ✅ Prepare update data
        $updateData = [
            'fabric_id'   => $fabric_id,
            'design_no'   => $design_no,
            'style_title' => $style_title,
            'style_image' => $style_image,
            'extra_image' => $extra_image,
            'updated_at'  => date('Y-m-d H:i:s')
        ];

        // Save update
        $result = $this->AdminModel->updateStyleDetails($updateData, $style_id);

        if ($result) {
            $this->session->set_flashdata('success', 'Style updated successfully.');
        } else {
            $this->session->set_flashdata('error', 'Failed to update style.');
        }

        redirect(base_url('admin/style'));
    }

    // Load edit view if GET
    $data['fabricName'] = $this->AdminModel->getAllFabric();
    $UpdateStyle = $this->AdminModel->UpdateStyle($id);

    $data['SEO'] = ['pageTitle' => 'Update Style'];
    $data['page'] = 'edit-style';
    $data['content'] = ['UpdateStyle' => $UpdateStyle];

    $this->load->view('admin/template', $data);
}


 public function updateStyle()
{
    if (empty($this->session->userdata('id'))) {
        redirect('admin');
        return;
    }

    $post = $this->input->post();
    $id         = $post['id'];
    $fabric_id  = $post['fabric_id'];
    $style_title = $post['style_title'];

    // Get design_no from fabric
    $fabric = $this->db->select('design_no')
        ->from('tb_fabric')
        ->where('fabric_id', $fabric_id)
        ->get()
        ->row();

    if (!$fabric) {
        $this->session->set_flashdata('error', 'Invalid fabric selected.');
        redirect('admin/style');
        return;
    }

    $design_no   = strtolower(str_replace(' ', '-', $fabric->design_no));
    $subfolders  = ['front', 'back', 'interior', 'pant'];

    $style_image      = '';
    $extra_image      = '';

    // ✅ Handle style_image upload
    if (!empty($_FILES['style_image']['name'])) {
        $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['style_image']['name']));

        // 1️⃣ Create empty subfolders in S3
        foreach ($subfolders as $folder) {
            $folder_key = S3_TYPE . "/fabric/{$design_no}/{$folder}/";
            try {
                $this->s3->putObject([
                    'Bucket' => $this->S3_BUCKET,
                    'Key'    => $folder_key,
                    'Body'   => "",
                    'ACL'    => 'public-read'
                ]);
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('image_upload_error', $e->getMessage());
                redirect(base_url('admin/style'));
                return;
            }
        }

        // Delete old image if exists
        $old_style = $post['old_style_image'] ?? '';
        if ($old_style) {
            try {
                $this->s3->deleteObject([
                    'Bucket' => $this->S3_BUCKET,
                    'Key'    => S3_TYPE . "/fabric/{$old_style}"
                ]);
            } catch (Aws\Exception\AwsException $e) {
                log_message('error', 'Failed to delete old style image: ' . $e->getMessage());
            }
        }

        // Upload new style image
        $style_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name}";
        try {
            $this->s3->putObject([
                'Bucket'      => $this->S3_BUCKET,
                'Key'         => $style_key,
                'SourceFile'  => $_FILES['style_image']['tmp_name'],
                'ACL'         => 'public-read',
                'ContentType' => mime_content_type($_FILES['style_image']['tmp_name'])
            ]);
        } catch (Aws\Exception\AwsException $e) {
            $this->session->set_flashdata('image_upload_error', $e->getMessage());
            redirect(base_url('admin/style'));
            return;
        }

        $style_image = "{$design_no}/front/{$file_name}";
    }

    // ✅ Handle extra_image upload
    if (!empty($_FILES['extra_image']['name'])) {
        $file_name_extra = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));

        // Delete old extra image if exists
        $old_extra = $post['old_extra_image'] ?? '';
        if ($old_extra) {
            try {
                $this->s3->deleteObject([
                    'Bucket' => $this->S3_BUCKET,
                    'Key'    => S3_TYPE . "/fabric/{$old_extra}"
                ]);
            } catch (Aws\Exception\AwsException $e) {
                log_message('error', 'Failed to delete old extra image: ' . $e->getMessage());
            }
        }

        $extra_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name_extra}";
        try {
            $this->s3->putObject([
                'Bucket'      => $this->S3_BUCKET,
                'Key'         => $extra_key,
                'SourceFile'  => $_FILES['extra_image']['tmp_name'],
                'ACL'         => 'public-read',
                'ContentType' => mime_content_type($_FILES['extra_image']['tmp_name'])
            ]);
        } catch (Aws\Exception\AwsException $e) {
            $this->session->set_flashdata('image_upload_error', $e->getMessage());
            redirect(base_url('admin/style'));
            return;
        }

        $extra_image = "{$design_no}/front/{$file_name_extra}";
    }

    // Prepare update data
    $updateData = [
        'fabric_id'   => $fabric_id,
        'style_title' => $style_title,
        'updated_at'  => date('Y-m-d H:i:s')
    ];

    if ($style_image) {
        $updateData['style_image'] = $style_image;
    }
    if ($extra_image) {
        $updateData['extra_image'] = $extra_image;
    }

    // Update style in DB
    $this->AdminModel->updateStyleFabricWise($id, $updateData);

    $this->session->set_flashdata('success', 'Style updated successfully!');
    redirect('admin/style');
}



    //Jacket Lapels

    public function jacketLapels()
    {
        // Check if user is logged in (optional)
        if ($this->session->userdata('id')) {

            // Get all lapels from model
            $jacketLapels = $this->AdminModel->getAllJacketLapels();
            // print_r($jacketLapels);die();
            // Pass data to view
            $data['content'] = array(
                'jacketLapels' => $jacketLapels,
            );

            $data['SEO'] = array('pageTitle' => 'Jacket Lapels');
            $data['page'] = 'jacket-lapels';

            // Load the main admin template with embedded page
            $this->load->view('admin/template', $data);
        } else {
            // Redirect to login if session expired
            redirect(base_url('admin'));
        }
    }

    public function addJacketLapels()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabricName();
            // $data['fabricName'] = $this->AdminModel->getAllFabricName();


            //  print_r $data['fabricName'];die();


            $data['SEO'] = array('pageTitle' => 'Add Jacket Lapels');
            $data['page'] = 'add-jacket-lapels';
            // $data['style'] = $selected_fabric;  // instead of only ['fabric_id' => $fabric_id]
            $data['content'] = array();

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }


public function saveJacketLapels()
{
    if (empty($this->session->userdata('id'))) {
        redirect('admin');
        return;
    }

    $post = $this->input->post();
    $fabric_id = $post['fabric_id'];
    $style_id = $post['style_id'];
    $jacket_lapels_title = $post['jacket_lapels_title'];

    // ✅ Get design_no from tb_fabric using fabric_id
    $this->db->select('design_no');
    $this->db->from('tb_fabric');
    $this->db->where('fabric_id', $fabric_id);
    $query = $this->db->get();
    $fabric = $query->row();

    if (!$fabric) {
        $this->session->set_flashdata('error', 'Invalid fabric selected.');
        redirect('admin/jacket-lapels');
        return;
    }

    // Normalize design_no for folder path
    $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));

    $image_name = '';
    $extra_image_name = '';

    // ✅ Upload main image to S3
    if (!empty($_FILES['image']['name'])) {
        $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
        $image_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name}";

        try {
            $this->s3->putObject([
                'Bucket'      => $this->S3_BUCKET,
                'Key'         => $image_key,
                'SourceFile'  => $_FILES['image']['tmp_name'],
                'ACL'         => 'public-read',
                'ContentType' => mime_content_type($_FILES['image']['tmp_name'])
            ]);
            $image_name = "{$design_no}/front/{$file_name}";
        } catch (Aws\Exception\AwsException $e) {
            $this->session->set_flashdata('error', 'Main image upload failed: ' . $e->getMessage());
            redirect('admin/jacket-lapels');
            return;
        }
    }

    // ✅ Upload extra image to S3
    if (!empty($_FILES['extra_image']['name'])) {
        $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
        $extra_key = S3_TYPE . "/fabric/{$design_no}/front/{$extra_file_name}";

        try {
            $this->s3->putObject([
                'Bucket'      => $this->S3_BUCKET,
                'Key'         => $extra_key,
                'SourceFile'  => $_FILES['extra_image']['tmp_name'],
                'ACL'         => 'public-read',
                'ContentType' => mime_content_type($_FILES['extra_image']['tmp_name'])
            ]);
            $extra_image_name = "{$design_no}/front/{$extra_file_name}";
        } catch (Aws\Exception\AwsException $e) {
            $this->session->set_flashdata('error', 'Extra image upload failed: ' . $e->getMessage());
            redirect('admin/jacket-lapels');
            return;
        }
    }

    // ✅ Insert into DB
    $jacketLapelsData = [
        'fabric_id'           => $fabric_id,
        'style_id'            => $style_id,
        'jacket_lapels_title' => $jacket_lapels_title,
        'image'               => $image_name,
        'extra_image'         => $extra_image_name,
        'created_at'          => date('Y-m-d H:i:s')
    ];

    $this->AdminModel->insertJacketLapels($jacketLapelsData);

    $this->session->set_flashdata('success', 'Jacket Lapels added successfully!');
    redirect('admin/jacket-lapels');
}


    public function JacketLapelsStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('id');
            $result = $this->AdminModel->JacketLapelsStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'jacket lapel status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'jacket lapel status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change jacket lapel status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function editJacketLapels($id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabric();
            $UpdateJacketStyle = $this->AdminModel->UpdateJacketStyle($id);

            //  print_r($this->db->last_query());die();
            //  print_r($UpdateJacketStyle);die();

            $data['SEO'] = array('pageTitle' => 'Update Jacket Lapels');
            $data['page'] = 'edit-jacket-lapels';
            $data['content'] = array(
                'UpdateJacketStyle' => $UpdateJacketStyle
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

public function updateJacketLapels()
{
    if (!empty($this->session->userdata('id'))) {
        $post = $this->input->post();
        $id = $post['id'];
        $style_id = $post['style_id'];
        $fabric_id = $post['fabric_id'];
        $jacket_lapels_title = $post['jacket_lapels_title'];

        // Get fabric design_no
        $fabric = $this->db->select('design_no')
            ->from('tb_fabric')
            ->where('fabric_id', $fabric_id)
            ->get()
            ->row();

        if (!$fabric) {
            $this->session->set_flashdata('error', 'Invalid fabric selected.');
            redirect('admin/jacket-lapels');
            return;
        }

        $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));

        // Prepare update data
        $updateData = [
            'style_id'            => $style_id,
            'fabric_id'           => $fabric_id,
            'jacket_lapels_title' => $jacket_lapels_title
        ];

        // Upload main image to S3
        if (!empty($_FILES['image']['name'])) {
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
            $image_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name}";
            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $image_key,
                    'SourceFile'  => $_FILES['image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['image']['tmp_name'])
                ]);
                $updateData['image'] = "{$design_no}/front/{$file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Main image upload failed: ' . $e->getMessage());
                redirect('admin/jacket-lapels');
                return;
            }
        }

        // Upload extra image to S3
        if (!empty($_FILES['extra_image']['name'])) {
            $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
            $extra_image_key = S3_TYPE . "/fabric/{$design_no}/front/{$extra_file_name}";
            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $extra_image_key,
                    'SourceFile'  => $_FILES['extra_image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['extra_image']['tmp_name'])
                ]);
                $updateData['extra_image'] = "{$design_no}/front/{$extra_file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Extra image upload failed: ' . $e->getMessage());
                redirect('admin/jacket-lapels');
                return;
            }
        }

        // Update DB
        $this->AdminModel->updateJacketLapels($id, $updateData);

        $this->session->set_flashdata('success', 'Jacket lapels updated successfully!');
        redirect('admin/jacket-lapels');
    } else {
        redirect('admin');
    }
}



    // public function get_styles_by_fabric($fabric_id) {

    //     // print_r($_POST);
    //     // print_r($_SESSION);

    //     $styles = $this->Admin_model->getStylesByFabricId($fabric_id);
    // // print_r($this->db->last_query());die();
    //     echo json_encode($styles);
    // }


    public function get_styles_by_fabric($fabric_id)
    {

        // Fetch styles by fabric_id
        $styles = $this->AdminModel->getStylesByFabricId($fabric_id);

        // print_r($styles);die();

        // Return as JSON
        header('Content-Type: application/json');
        echo json_encode($styles);
    }


    //Lapel Width

    public function lapelWidth()
    {
        // Check if user is logged in (optional)
        if ($this->session->userdata('id')) {

            // // Get all lapels from model
            $lapelWidth = $this->AdminModel->getAllLapelWidth();
            // print_r($lapelWidth);die();
            // Pass data to view
            $data['content'] = array(
                'lapelWidth' => $lapelWidth,
            );

            $data['SEO'] = array('pageTitle' => 'Jacket Width');
            $data['page'] = 'lapel_width';

            // Load the main admin template with embedded page
            $this->load->view('admin/template', $data);
        } else {
            // Redirect to login if session expired
            redirect(base_url('admin'));
        }
    }


    public function addLapelWidth()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabricName();
            // $data['fabricName'] = $this->AdminModel->getAllFabricName();


            //  print_r $data['fabricName'];die();


            $data['SEO'] = array('pageTitle' => 'Add Lapel Width');
            $data['page'] = 'add-lapel-width';
            // $data['style'] = $selected_fabric;  // instead of only ['fabric_id' => $fabric_id]
            $data['content'] = array();

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }



public function saveLapelWidth()
{
    if (!empty($this->session->userdata('id'))) {
        $post = $this->input->post();
        $fabric_id = $post['fabric_id'];
        $style_id = $post['style_id'];
        $lapel_id = $post['lapel_id'];
        $lapel_width_title = $post['lapel_width_title'];

        // Load model
        $this->load->model('AdminModel');

       
        $fabric = $this->db->select('design_no')
            ->from('tb_fabric')
            ->where('fabric_id', $fabric_id)
            ->get()
            ->row();

        if (!$fabric) {
            $this->session->set_flashdata('error', 'Invalid fabric selected.');
            redirect('admin/lapel-width');
            return;
        }

     
        $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));

       
        $image_name = '';
        if (!empty($_FILES['image']['name'])) {
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
            $image_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $image_key,
                    'SourceFile'  => $_FILES['image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['image']['tmp_name'])
                ]);
                $image_name = "{$design_no}/front/{$file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Main image upload failed: ' . $e->getMessage());
                redirect('admin/lapel-width');
                return;
            }
        }

     
        $extra_image_name = '';
        if (!empty($_FILES['extra_image']['name'])) {
            $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
            $extra_image_key = S3_TYPE . "/fabric/{$design_no}/front/{$extra_file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $extra_image_key,
                    'SourceFile'  => $_FILES['extra_image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['extra_image']['tmp_name'])
                ]);
                $extra_image_name = "{$design_no}/front/{$extra_file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Extra image upload failed: ' . $e->getMessage());
                redirect('admin/lapel-width');
                return;
            }
        }

     
        $LapelWidthData = array(
            'fabric_id'         => $fabric_id,
            'style_id'          => $style_id,
            'lapel_id'          => $lapel_id,
            'lapel_width_title' => $lapel_width_title,
            'image'             => !empty($image_name) ? $image_name : '',
            'extra_image'       => !empty($extra_image_name) ? $extra_image_name : '',
            'created_at'        => date('Y-m-d H:i:s')
        );

      
        $this->AdminModel->insertWidthLapels($LapelWidthData);

        $this->session->set_flashdata('success', 'Lapel Width added successfully!');
        redirect('admin/lapel-width');
    } else {
        redirect('admin');
    }
}





    public function LapelsWidthStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('lapel_width_id');
            $result = $this->AdminModel->LapelsWidthStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'lapel width status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'lapel width status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change lapel width status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function editLapelWidth($id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabric();
            $UpdateLapelWidthStyle = $this->AdminModel->UpdateLapelWidthStyle($id);

            //  print_r($this->db->last_query());die();
            //  print_r($UpdateJacketStyle);die();

            $data['SEO'] = array('pageTitle' => 'Update Lapel Width');
            $data['page'] = 'edit-lapel-width';
            $data['content'] = array(
                'UpdateLapelWidthStyle' => $UpdateLapelWidthStyle
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

   public function updateLapelWidth()
{
    if (!empty($this->session->userdata('id'))) {
        $post = $this->input->post();
        $id = $post['id'];
        $style_id = $post['style_id'];
        $fabric_id = $post['fabric_id'];
        $lapel_id = $post['lapel_id'];
        $lapel_width_title = $post['lapel_width_title'];

        // ✅ Get fabric design_no
        $fabric = $this->db->select('design_no')
            ->from('tb_fabric')
            ->where('fabric_id', $fabric_id)
            ->get()
            ->row();

        if (!$fabric) {
            $this->session->set_flashdata('error', 'Invalid fabric selected.');
            redirect('admin/lapel-width');
            return;
        }

        $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));

        // ✅ Prepare update data
        $updateData = array(
            'style_id'           => $style_id,
            'fabric_id'          => $fabric_id,
            'lapel_id'           => $lapel_id,
            'lapel_width_title'  => $lapel_width_title,
        );

        // ✅ Handle main image upload to S3
        if (!empty($_FILES['image']['name'])) {
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
            $image_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $image_key,
                    'SourceFile'  => $_FILES['image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['image']['tmp_name'])
                ]);

                $updateData['image'] = "{$design_no}/front/{$file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Main image upload failed: ' . $e->getMessage());
                redirect('admin/lapel-width');
                return;
            }
        }

        // ✅ Handle extra image upload to S3
        if (!empty($_FILES['extra_image']['name'])) {
            $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
            $extra_image_key = S3_TYPE . "/fabric/{$design_no}/front/{$extra_file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $extra_image_key,
                    'SourceFile'  => $_FILES['extra_image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['extra_image']['tmp_name'])
                ]);

                $updateData['extra_image'] = "{$design_no}/front/{$extra_file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Extra image upload failed: ' . $e->getMessage());
                redirect('admin/lapel-width');
                return;
            }
        }

        // ✅ Update in DB
        $this->AdminModel->updateLapelWidth($id, $updateData);

        $this->session->set_flashdata('success', 'Lapel width updated successfully!');
        redirect('admin/lapel-width');
    } else {
        redirect('admin');
    }
}


    public function get_jacket_lapels_title($style_id)
    {
        $jacketLapels = $this->AdminModel->getJacketLapelsByStyleId($style_id);

        header('Content-Type: application/json');
        echo json_encode($jacketLapels);
    }




    //Pocket Lapels

    public function pocketStyle()
    {
        // Check if user is logged in (optional)
        if ($this->session->userdata('id')) {

            // Get all lapels from model
            $pocketStyle = $this->AdminModel->getAllPocketStyle();
            //  print_r($pocketStyle);die();
            // Pass data to view
            $data['content'] = array(
                'pocketStyle' => $pocketStyle,
            );

            $data['SEO'] = array('pageTitle' => 'Pocket Style');
            $data['page'] = 'pocket-style';

            // Load the main admin template with embedded page
            $this->load->view('admin/template', $data);
        } else {
            // Redirect to login if session expired
            redirect(base_url('admin'));
        }
    }

    public function addPocketStyle()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabricName();
            // $data['fabricName'] = $this->AdminModel->getAllFabricName();


            //  print_r $data['fabricName'];die();


            $data['SEO'] = array('pageTitle' => 'Add Pocket Style');
            $data['page'] = 'add-pocket-style';
            // $data['style'] = $selected_fabric;  // instead of only ['fabric_id' => $fabric_id]
            $data['content'] = array();

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

public function savePocketStyle()
{
    if (!empty($this->session->userdata('id'))) {
        $post = $this->input->post();
        $fabric_id = $post['fabric_id'];
        $style_id = $post['style_id'];
        $pocket_style_name = $post['pocket_style_name'];

        // Load model
        $this->load->model('AdminModel');

        // ✅ Get design_no from tb_fabric using fabric_id
        $this->db->select('design_no');
        $this->db->from('tb_fabric');
        $this->db->where('fabric_id', $fabric_id);
        $query = $this->db->get();
        $fabric = $query->row();

        if (!$fabric) {
            $this->session->set_flashdata('error', 'Invalid fabric selected.');
            redirect('admin/pocket-style');
            return;
        }

        // ✅ Create design_no folder name
        $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));

        // ✅ Handle main image upload to S3
        $image_name = '';
        if (!empty($_FILES['image']['name'])) {
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
            $image_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $image_key,
                    'SourceFile'  => $_FILES['image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['image']['tmp_name'])
                ]);

                $image_name = "{$design_no}/front/{$file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Main image upload failed: ' . $e->getMessage());
                redirect('admin/pocket-style');
                return;
            }
        }

        // ✅ Handle extra image upload to S3
        $extra_image_name = '';
        if (!empty($_FILES['extra_image']['name'])) {
            $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
            $extra_image_key = S3_TYPE . "/fabric/{$design_no}/front/{$extra_file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $extra_image_key,
                    'SourceFile'  => $_FILES['extra_image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['extra_image']['tmp_name'])
                ]);

                $extra_image_name = "{$design_no}/front/{$extra_file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Extra image upload failed: ' . $e->getMessage());
                redirect('admin/pocket-style');
                return;
            }
        }

        // ✅ Insert into db
        $PocketStyleData = array(
            'fabric_id'         => $fabric_id,
            'style_id'          => $style_id,
            'pocket_style_name' => $pocket_style_name,
            'image'             => $image_name,
            'extra_image'       => $extra_image_name,
            'created_at'        => date('Y-m-d H:i:s')
        );

        $this->AdminModel->insertPocketStyle($PocketStyleData);
        $this->session->set_flashdata('success', 'Pocket Style added successfully!');
        redirect('admin/pocket-style');
    } else {
        redirect('admin');
    }
}



    public function pocketStyleStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('lapel_id');
            $result = $this->AdminModel->pocketStyleStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'pocket style status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'pocket style status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change pocket style status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function editPocketStyle($id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabric();
            $UpdatePocketStyle = $this->AdminModel->UpdatePocketStyle($id);

            //  print_r($this->db->last_query());die();
            //  print_r($UpdateJacketStyle);die();

            $data['SEO'] = array('pageTitle' => 'Update Pocket Style');
            $data['page'] = 'edit-pocket-style';
            $data['content'] = array(
                'UpdatePocketStyle' => $UpdatePocketStyle
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }


public function updatePocketStyle()
{
    if (!empty($this->session->userdata('id'))) {
        $post = $this->input->post();
        $id = $post['id'];
        $style_id = $post['style_id'];
        $fabric_id = $post['fabric_id'];
        $pocket_style_name = $post['pocket_style_name'];

        // ✅ Get fabric design_no
        $fabric = $this->db->select('design_no')
            ->from('tb_fabric')
            ->where('fabric_id', $fabric_id)
            ->get()
            ->row();

        if (!$fabric) {
            $this->session->set_flashdata('error', 'Invalid fabric selected.');
            redirect('admin/pocket-style');
            return;
        }

        $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));

        // ✅ Handle main image upload (to S3)
        $image_name = '';
        if (!empty($_FILES['image']['name'])) {
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
            $image_key = S3_TYPE . "/fabric/{$design_no}/front/{$file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $image_key,
                    'SourceFile'  => $_FILES['image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['image']['tmp_name'])
                ]);

                $image_name = "{$design_no}/front/{$file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Main image upload failed: ' . $e->getMessage());
                redirect('admin/pocket-style');
                return;
            }
        }

        // ✅ Handle extra image upload (to S3)
        $extra_image_name = '';
        if (!empty($_FILES['extra_image']['name'])) {
            $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
            $extra_image_key = S3_TYPE . "/fabric/{$design_no}/front/{$extra_file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $extra_image_key,
                    'SourceFile'  => $_FILES['extra_image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['extra_image']['tmp_name'])
                ]);

                $extra_image_name = "{$design_no}/front/{$extra_file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Extra image upload failed: ' . $e->getMessage());
                redirect('admin/pocket-style');
                return;
            }
        }

        // ✅ Prepare update data
        $updateData = array(
            'style_id'          => $style_id,
            'fabric_id'         => $fabric_id,
            'pocket_style_name' => $pocket_style_name,
        );

        if (!empty($image_name)) {
            $updateData['image'] = $image_name;
        }

        if (!empty($extra_image_name)) {
            $updateData['extra_image'] = $extra_image_name;
        }

        // ✅ Update DB
        $this->AdminModel->updatePocketStyles($id, $updateData);

        $this->session->set_flashdata('success', 'Pocket style updated successfully!');
        redirect('admin/pocket-style');
    } else {
        redirect('admin');
    }
}




    //Back Style

    public function backStyle()
    {
        // Check if user is logged in (optional)
        if ($this->session->userdata('id')) {

            // Get all lapels from model
            $backStyle = $this->AdminModel->getAllBackStyle();
            //  print_r($backStyle);die();
            // Pass data to view
            $data['content'] = array(
                'backStyle' => $backStyle,
            );

            $data['SEO'] = array('pageTitle' => 'Back Style');
            $data['page'] = 'back-style';

            // Load the main admin template with embedded page
            $this->load->view('admin/template', $data);
        } else {
            // Redirect to login if session expired
            redirect(base_url('admin'));
        }
    }

    public function addBackStyle()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabricName();
            // $data['fabricName'] = $this->AdminModel->getAllFabricName();


            //  print_r $data['fabricName'];die();


            $data['SEO'] = array('pageTitle' => 'Add Back Style');
            $data['page'] = 'add-back-style';
            // $data['style'] = $selected_fabric;  // instead of only ['fabric_id' => $fabric_id]
            $data['content'] = array();

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

public function saveBackStyle()
{
    if (!empty($this->session->userdata('id'))) {
        $post = $this->input->post();
        $fabric_id = $post['fabric_id'];
        $style_id = $post['style_id'];
        $back_style_name = $post['back_style_name'];

        // Load model
        $this->load->model('AdminModel');

        // ✅ Get design_no from tb_fabric using fabric_id
        $fabric = $this->db->select('design_no')
            ->from('tb_fabric')
            ->where('fabric_id', $fabric_id)
            ->get()
            ->row();

        if (!$fabric) {
            $this->session->set_flashdata('error', 'Invalid fabric selected.');
            redirect('admin/back-style');
            return;
        }

        $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));

        // ✅ Handle main image upload (to S3)
        $image_name = '';
        if (!empty($_FILES['image']['name'])) {
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
            $image_key = S3_TYPE . "/fabric/{$design_no}/back/{$file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $image_key,
                    'SourceFile'  => $_FILES['image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['image']['tmp_name'])
                ]);

                $image_name = "{$design_no}/back/{$file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Main image upload failed: ' . $e->getMessage());
                redirect('admin/back-style');
                return;
            }
        }

        // ✅ Handle extra image upload (to S3)
        $extra_image_name = '';
        if (!empty($_FILES['extra_image']['name'])) {
            $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
            $extra_image_key = S3_TYPE . "/fabric/{$design_no}/back/{$extra_file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $extra_image_key,
                    'SourceFile'  => $_FILES['extra_image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['extra_image']['tmp_name'])
                ]);

                $extra_image_name = "{$design_no}/back/{$extra_file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Extra image upload failed: ' . $e->getMessage());
                redirect('admin/back-style');
                return;
            }
        }

        // ✅ Insert into database
        $backStyleData = array(
            'fabric_id'       => $fabric_id,
            'style_id'        => $style_id,
            'back_style_name' => $back_style_name,
            'image'           => !empty($image_name) ? $image_name : '',
            'extra_image'     => !empty($extra_image_name) ? $extra_image_name : '',
            'created_at'      => date('Y-m-d H:i:s')
        );

        $this->AdminModel->insertBackStyle($backStyleData);

        $this->session->set_flashdata('success', 'Back Style added successfully!');
        redirect('admin/back-style');
    } else {
        redirect('admin');
    }
}


    public function  BackStyleStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('lapel_id');
            $result = $this->AdminModel->BackStyleStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'back style status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'back style status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change back style status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function editBackStyle($id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabric();
            $UpdateBackStyle = $this->AdminModel->UpdateBackStyle($id);

            //  print_r($this->db->last_query());die();
            //  print_r($UpdateJacketStyle);die();

            $data['SEO'] = array('pageTitle' => 'Update Back Style');
            $data['page'] = 'edit-back-style';
            $data['content'] = array(
                'UpdateBackStyle' => $UpdateBackStyle
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }


public function updateBackStyle()
{
    if (!empty($this->session->userdata('id'))) {
        $post = $this->input->post();
        $id = $post['id'];
        $style_id = $post['style_id'];
        $fabric_id = $post['fabric_id'];
        $back_style_name = $post['back_style_name'];

        // ✅ Get design_no
        $fabric = $this->db->select('design_no')
            ->from('tb_fabric')
            ->where('fabric_id', $fabric_id)
            ->get()
            ->row();

        if (!$fabric) {
            $this->session->set_flashdata('error', 'Invalid fabric selected.');
            redirect('admin/back-style');
            return;
        }

        $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));

        // ✅ Main image upload (to S3)
        $image_name = '';
        if (!empty($_FILES['image']['name'])) {
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
            $image_key = S3_TYPE . "/fabric/{$design_no}/back/{$file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $image_key,
                    'SourceFile'  => $_FILES['image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['image']['tmp_name'])
                ]);

                $image_name = "{$design_no}/back/{$file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Main image upload failed: ' . $e->getMessage());
                redirect('admin/back-style');
                return;
            }
        }

        // ✅ Extra image upload (to S3)
        $extra_image_name = '';
        if (!empty($_FILES['extra_image']['name'])) {
            $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
            $extra_image_key = S3_TYPE . "/fabric/{$design_no}/back/{$extra_file_name}";

            try {
                $this->s3->putObject([
                    'Bucket'      => $this->S3_BUCKET,
                    'Key'         => $extra_image_key,
                    'SourceFile'  => $_FILES['extra_image']['tmp_name'],
                    'ACL'         => 'public-read',
                    'ContentType' => mime_content_type($_FILES['extra_image']['tmp_name'])
                ]);

                $extra_image_name = "{$design_no}/back/{$extra_file_name}";
            } catch (Aws\Exception\AwsException $e) {
                $this->session->set_flashdata('error', 'Extra image upload failed: ' . $e->getMessage());
                redirect('admin/back-style');
                return;
            }
        }

        // ✅ Prepare update data
        $updateData = array(
            'style_id'        => $style_id,
            'fabric_id'       => $fabric_id,
            'back_style_name' => $back_style_name,
        );

        if (!empty($image_name)) {
            $updateData['image'] = $image_name;
        }

        if (!empty($extra_image_name)) {
            $updateData['extra_image'] = $extra_image_name;
        }

        // ✅ Update DB
        $this->AdminModel->updateBackStyles($id, $updateData);

        $this->session->set_flashdata('success', 'Back style updated successfully!');
        redirect('admin/back-style');
    } else {
        redirect('admin');
    }
}




    //Blazer Initials Master
    public function blazerInitials()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['blazerInitials'] = $this->AdminModel->getAllBlazerInitials();
            // print_r($data['blazerInitials']);die();
            $data['content'] = array();
            $data['SEO'] = array('pageTitle' => 'Blazer Initials');
            $data['page'] = 'blazer-initials';
            // print_r($data);die();
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin/fabric'));
        }
    }


    public function addBlazerInitials()
    {
        if (!empty($this->session->userdata('id'))) {

            $data['SEO'] = array('pageTitle' => 'Add Blazer Initials');
            $data['page'] = 'add-blazer-initials';
            $data['content'] = array();
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function saveBlazerInitials()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $thread_color_code = $post['color_thread'];
            $image_name = '';

            // Upload folder
            $upload_folder = './uploads/blazer-initials/';

            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            // Handle image upload
            if (!empty($_FILES['image']['name'])) {
                $original_filename = $_FILES['image']['name'];

                // Clean filename: remove unsafe characters
                $clean_filename = preg_replace('/[^a-zA-Z0-9\.-]/', '-', strtolower($original_filename));

                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $clean_filename;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name']; // ✅ only filename, not full path
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/blazer-initials');
                    return;
                }
            }

            // Prepare and save data
            $data = array(
                'color_thread' => $thread_color_code,
                'image'        => $image_name, // ✅ stores only the file name
                'created_at'   => date('Y-m-d H:i:s')
            );

            $this->load->model('AdminModel');
            $this->AdminModel->insertBlazerInitials($data);

            $this->session->set_flashdata('success', 'Blazer Initial saved successfully!');
            redirect('admin/blazer-initials');
        } else {
            redirect('admin');
        }
    }


    public function BlazerInitialsStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('id');
            $result = $this->AdminModel->BlazerInitialsStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'blazer initials status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'blazer initials status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change blazer initials status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function editBlazerInitials($id = "")
    {
        if (!empty($this->session->userdata('id'))) {

            $UpdateBlazerInitials = $this->AdminModel->UpdateBlazerInitials($id);

            //  print_r($this->db->last_query());die();
            //  print_r($UpdateFabric);die();

            $data['SEO'] = array('pageTitle' => 'Update Blazer Initials');
            $data['page'] = 'edit-blazer-initials';
            $data['content'] = array(
                'UpdateBlazerInitials' => $UpdateBlazerInitials
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function updateBlazerInitials()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $id = $post['id'];
            $thread_color_code = $post['color_thread'];
            $image_name = '';

            // Upload path
            $upload_folder = './uploads/blazer-initials/';

            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            // Check for image upload
            if (!empty($_FILES['image']['name'])) {
                $original_filename = $_FILES['image']['name'];

                // Sanitize file name
                $clean_filename = preg_replace('/[^a-zA-Z0-9\.-]/', '-', strtolower($original_filename));

                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $clean_filename;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name']; // ✅ Only image name, not full path
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/blazer-initials');
                    return;
                }
            }

            // Prepare update data
            $updateData = array(
                'color_thread' => $thread_color_code,
                'created_at'   => date('Y-m-d H:i:s')
            );


            if (!empty($image_name)) {
                $updateData['image'] = $image_name;
            }

            // print_r($updateData);die();
            $this->AdminModel->updateBlazerInitialss($id, $updateData);
            // print_r($this->db->last_query());die();

            $this->session->set_flashdata('success', 'Blazer Initial updated successfully!');
            redirect('admin/blazer-initials');
        } else {
            redirect('admin');
        }
    }



    //sleeve button

    public function sleeveButton()
    {
        // Check if user is logged in (optional)
        if ($this->session->userdata('id')) {

            // Get all lapels from model
            $sleeveButton = $this->AdminModel->getAllSleeveButton();
            //  print_r($pocketStyle);die();
            // Pass data to view
            $data['content'] = array(
                'sleeveButton' => $sleeveButton,
            );

            $data['SEO'] = array('pageTitle' => 'Sleeve Buttons');
            $data['page'] = 'sleeve-buttons';

            // Load the main admin template with embedded page
            $this->load->view('admin/template', $data);
        } else {
            // Redirect to login if session expired
            redirect(base_url('admin'));
        }
    }


    public function addSleeveButton()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabricName();
            // $data['fabricName'] = $this->AdminModel->getAllFabricName();


            //  print_r $data['fabricName'];die();


            $data['SEO'] = array('pageTitle' => 'Add Sleeve Button');
            $data['page'] = 'add-sleeve-button';
            // $data['style'] = $selected_fabric;  // instead of only ['fabric_id' => $fabric_id]
            $data['content'] = array();

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function saveSleeveButton()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $fabric_id = $post['fabric_id'];
            $style_id = $post['style_id'];
            $sleeve_button_name = $post['sleeve_button_name'];

            $this->load->model('AdminModel');

            // Get design_no
            $this->db->select('design_no');
            $this->db->from('tb_fabric');
            $this->db->where('fabric_id', $fabric_id);
            $query = $this->db->get();
            $fabric = $query->row();

            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/front/';
            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $this->load->library('upload');

            // Main image upload
            $image_name = '';
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->upload->initialize($config);
                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/sleeve-button');
                    return;
                }
            }

            // Extra image upload
            $extra_image_name = '';
            if (!empty($_FILES['extra_image']['name'])) {
                $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
                $extra_config['upload_path']   = $upload_folder;
                $extra_config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $extra_config['max_size']      = 2048;
                $extra_config['file_name']     = $extra_file_name;

                $this->upload->initialize($extra_config);
                if ($this->upload->do_upload('extra_image')) {
                    $extraUploadData = $this->upload->data();
                    $extra_image_name = $extraUploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/sleeve-button');
                    return;
                }
            }

            // Prepare data for insert
            $SleeveButtonData = array(
                'fabric_id'          => $fabric_id,
                'style_id'           => $style_id,
                'sleeve_button_name' => $sleeve_button_name,
                'image'              => $design_no . '/front/' . $image_name,
                'extra_image'        => !empty($extra_image_name) ? $design_no . '/front/' . $extra_image_name : '',
                'created_at'         => date('Y-m-d H:i:s')
            );

            $this->AdminModel->insertSleeveButton($SleeveButtonData);

            $this->session->set_flashdata('success', 'Sleeve Button added successfully!');
            redirect('admin/sleeve-button');
        } else {
            redirect('admin');
        }
    }


    public function  sleeveButtonStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('lapel_id');
            $result = $this->AdminModel->sleeveButtonStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'sleeve button status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'sleeve button status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change sleeve button status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function editSleeveButton($id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabric();
            $UpdateSleeveButton = $this->AdminModel->UpdateSleeveButton($id);

            //  print_r($this->db->last_query());die();
            //  print_r($UpdateSleeveButton);die();

            $data['SEO'] = array('pageTitle' => 'Update Sleeve Button');
            $data['page'] = 'edit-sleeve-button';
            $data['content'] = array(
                'UpdateSleeveButton' => $UpdateSleeveButton
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function updateSleeveButton()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $id = $post['id'];
            $style_id = $post['style_id'];
            $fabric_id = $post['fabric_id'];
            $sleeve_button_name = $post['sleeve_button_name'];

            // Get fabric design_no
            $fabric = $this->db->select('design_no')
                ->from('tb_fabric')
                ->where('fabric_id', $fabric_id)
                ->get()
                ->row();

            if (!$fabric) {
                $this->session->set_flashdata('error', 'Invalid fabric selected.');
                redirect('admin/sleeve-button');
                return;
            }

            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/front/';
            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $this->load->library('upload');

            // Handle main image upload
            $image_name = '';
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->upload->initialize($config);
                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/sleeve-button');
                    return;
                }
            }

            // Handle extra image upload
            $extra_image_name = '';
            if (!empty($_FILES['extra_image']['name'])) {
                $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
                $extra_config['upload_path']   = $upload_folder;
                $extra_config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $extra_config['max_size']      = 2048;
                $extra_config['file_name']     = $extra_file_name;

                $this->upload->initialize($extra_config);
                if ($this->upload->do_upload('extra_image')) {
                    $extraUploadData = $this->upload->data();
                    $extra_image_name = $extraUploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/sleeve-button');
                    return;
                }
            }

            // Prepare update data
            $updateData = array(
                'style_id'           => $style_id,
                'fabric_id'          => $fabric_id,
                'sleeve_button_name' => $sleeve_button_name,
            );

            if (!empty($image_name)) {
                $updateData['image'] = $design_no . '/front/' . $image_name;
            }

            if (!empty($extra_image_name)) {
                $updateData['extra_image'] = $design_no . '/front/' . $extra_image_name;
            }

            // Perform update
            $this->AdminModel->updatesleeveButtons($id, $updateData);

            $this->session->set_flashdata('success', 'Sleeve button updated successfully!');
            redirect('admin/sleeve-button');
        } else {
            redirect('admin');
        }
    }

    //button hole

    public function buttonHole()
    {
        // Check if user is logged in (optional)
        if ($this->session->userdata('id')) {

            // Get all lapels from model
            $buttonHoles = $this->AdminModel->getAllButtonHole();
            //  print_r($pocketStyle);die();
            // Pass data to view
            $data['content'] = array(
                'buttonHoles' => $buttonHoles,
            );

            $data['SEO'] = array('pageTitle' => 'Button Holes');
            $data['page'] = 'button-holes';

            // Load the main admin template with embedded page
            $this->load->view('admin/template', $data);
        } else {
            // Redirect to login if session expired
            redirect(base_url('admin'));
        }
    }


    public function addButtonHole()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabricName();
            // $data['fabricName'] = $this->AdminModel->getAllFabricName();


            //  print_r $data['fabricName'];die();


            $data['SEO'] = array('pageTitle' => 'Add Button Hole');
            $data['page'] = 'add-button-hole';
            // $data['style'] = $selected_fabric;  // instead of only ['fabric_id' => $fabric_id]
            $data['content'] = array();

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function saveButtonHole()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $fabric_id = $post['fabric_id'];
            $style_id = $post['style_id'];
            $button_hole_name = $post['button_hole_name'];

            // Load model
            $this->load->model('AdminModel');

            // Get design_no from tb_fabric
            $fabric = $this->db->select('design_no')
                ->from('tb_fabric')
                ->where('fabric_id', $fabric_id)
                ->get()
                ->row();

            if (!$fabric) {
                $this->session->set_flashdata('error', 'Invalid fabric selected.');
                redirect('admin/button-holes');
                return;
            }

            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/front/';
            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $this->load->library('upload');

            // Handle main image upload
            $image_name = '';
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->upload->initialize($config);
                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button-holes');
                    return;
                }
            }

            // Handle extra image upload
            $extra_image_name = '';
            if (!empty($_FILES['extra_image']['name'])) {
                $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
                $extra_config['upload_path']   = $upload_folder;
                $extra_config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $extra_config['max_size']      = 2048;
                $extra_config['file_name']     = $extra_file_name;

                $this->upload->initialize($extra_config);
                if ($this->upload->do_upload('extra_image')) {
                    $extraUploadData = $this->upload->data();
                    $extra_image_name = $extraUploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button-holes');
                    return;
                }
            }

            // Prepare data
            $ButtonHoleData = array(
                'fabric_id'         => $fabric_id,
                'style_id'          => $style_id,
                'button_hole_name'  => $button_hole_name,
                'image'             => $image_name ? ($design_no . '/front/' . $image_name) : '',
                'extra_image'       => $extra_image_name ? ($design_no . '/front/' . $extra_image_name) : '',
                'created_at'        => date('Y-m-d H:i:s')
            );

            $this->AdminModel->insertButtonHole($ButtonHoleData);

            $this->session->set_flashdata('success', 'Button Hole added successfully!');
            redirect('admin/button-holes');
        } else {
            redirect('admin');
        }
    }

    public function buttonHoleStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('lapel_id');
            $result = $this->AdminModel->buttonHoleStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'button holes status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'button holes status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change button holes status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function editButtonHole($id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabric();
            $UpdateButtonHole = $this->AdminModel->UpdateButtonHole($id);

            //  print_r($this->db->last_query());die();
            //   print_r($UpdateButtonHole);die();

            $data['SEO'] = array('pageTitle' => 'Update Button Holes');
            $data['page'] = 'edit-button-hole';
            $data['content'] = array(
                'UpdateButtonHole' => $UpdateButtonHole
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function updateButtonHole()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $id = $post['id'];
            $style_id = $post['style_id'];
            $fabric_id = $post['fabric_id'];
            $button_hole_name = $post['button_hole_name'];

            // Get design_no
            $fabric = $this->db->select('design_no')
                ->from('tb_fabric')
                ->where('fabric_id', $fabric_id)
                ->get()
                ->row();

            if (!$fabric) {
                $this->session->set_flashdata('error', 'Invalid fabric selected.');
                redirect('admin/button-holes');
                return;
            }

            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/front/';
            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $this->load->library('upload');

            // --- Main Image Upload ---
            $image_name = '';
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->upload->initialize($config);
                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button-holes');
                    return;
                }
            }

            // --- Extra Image Upload ---
            $extra_image_name = '';
            if (!empty($_FILES['extra_image']['name'])) {
                $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
                $extra_config['upload_path']   = $upload_folder;
                $extra_config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $extra_config['max_size']      = 2048;
                $extra_config['file_name']     = $extra_file_name;

                $this->upload->initialize($extra_config);
                if ($this->upload->do_upload('extra_image')) {
                    $extraUploadData = $this->upload->data();
                    $extra_image_name = $extraUploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button-holes');
                    return;
                }
            }

            // --- Prepare update data ---
            $updateData = array(
                'style_id' => $style_id,
                'fabric_id' => $fabric_id,
                'button_hole_name' => $button_hole_name,
            );

            if (!empty($image_name)) {
                $updateData['image'] = $design_no . '/front/' . $image_name;
            }

            if (!empty($extra_image_name)) {
                $updateData['extra_image'] = $design_no . '/front/' . $extra_image_name;
            }

            // --- Update DB ---
            $this->AdminModel->updateButtonHoles($id, $updateData);

            $this->session->set_flashdata('success', 'Button hole updated successfully!');
            redirect('admin/button-holes');
        } else {
            redirect('admin');
        }
    }


    //button Placement

    public function buttonPlacement()
    {
        // Check if user is logged in (optional)
        if ($this->session->userdata('id')) {

            // Get all lapels from model
            $buttonPlacement = $this->AdminModel->getAllButtonPlacement();
            //  print_r($buttonPlacement);die();
            // Pass data to view
            $data['content'] = array(
                'buttonPlacement' => $buttonPlacement,
            );

            $data['SEO'] = array('pageTitle' => 'Button Placement');
            $data['page'] = 'button-placement';

            // Load the main admin template with embedded page
            $this->load->view('admin/template', $data);
        } else {
            // Redirect to login if session expired
            redirect(base_url('admin'));
        }
    }


    public function addButtonPlacement()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabricName();
            // $data['fabricName'] = $this->AdminModel->getAllFabricName();


            //  print_r $data['fabricName'];die();


            $data['SEO'] = array('pageTitle' => 'Add Button Placement');
            $data['page'] = 'add-button-placement';
            // $data['style'] = $selected_fabric;  // instead of only ['fabric_id' => $fabric_id]
            $data['content'] = array();

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function saveButtonPlacement()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $fabric_id = $post['fabric_id'];
            $style_id = $post['style_id'];
            $button_placement_name = $post['button_placement_name'];

            $this->load->model('AdminModel');

            // Get fabric design_no
            $fabric = $this->db->select('design_no')
                ->from('tb_fabric')
                ->where('fabric_id', $fabric_id)
                ->get()
                ->row();

            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/front/';

            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $this->load->library('upload');

            // --- Upload main image ---
            $image_name = '';
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->upload->initialize($config);
                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button-placement');
                    return;
                }
            }

            // --- Upload extra image ---
            $extra_image_name = '';
            if (!empty($_FILES['extra_image']['name'])) {
                $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
                $extra_config['upload_path']   = $upload_folder;
                $extra_config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $extra_config['max_size']      = 2048;
                $extra_config['file_name']     = $extra_file_name;

                $this->upload->initialize($extra_config);
                if ($this->upload->do_upload('extra_image')) {
                    $extraUploadData = $this->upload->data();
                    $extra_image_name = $extraUploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button-placement');
                    return;
                }
            }

            // Prepare insert data
            $ButtonPlacementData = array(
                'fabric_id'              => $fabric_id,
                'style_id'               => $style_id,
                'button_placement_name'  => $button_placement_name,
                'image'                  => $image_name ? $design_no . '/front/' . $image_name : '',
                'extra_image'            => $extra_image_name ? $design_no . '/front/' . $extra_image_name : '',
                'created_at'             => date('Y-m-d H:i:s')
            );

            $this->AdminModel->insertButtonPlacement($ButtonPlacementData);

            $this->session->set_flashdata('success', 'Button Placement added successfully!');
            redirect('admin/button-placement');
        } else {
            redirect('admin');
        }
    }


    public function buttonPlacementStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('lapel_id');
            $result = $this->AdminModel->buttonPlacementStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'button placement status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'button placement status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change button placement status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function editButtonPlacement($id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabric();
            $UpdateButtonPlacement = $this->AdminModel->UpdateButtonPlacement($id);

            //  print_r($this->db->last_query());die();
            //   print_r($UpdateButtonHole);die();

            $data['SEO'] = array('pageTitle' => 'Update Button Placement');
            $data['page'] = 'edit-button-placement';
            $data['content'] = array(
                'UpdateButtonPlacement' => $UpdateButtonPlacement
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function updateButtonPlacement()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $id = $post['id'];
            $style_id = $post['style_id'];
            $fabric_id = $post['fabric_id'];
            $button_placement_name = $post['button_placement_name'];

            // Get fabric design_no
            $fabric = $this->db->select('design_no')
                ->from('tb_fabric')
                ->where('fabric_id', $fabric_id)
                ->get()
                ->row();

            if (!$fabric) {
                $this->session->set_flashdata('error', 'Invalid fabric selected.');
                redirect('admin/button-placement');
                return;
            }

            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/front/';
            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $this->load->library('upload');

            // --- Handle main image ---
            $image_name = '';
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->upload->initialize($config);
                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button-placement');
                    return;
                }
            }

            // --- Handle extra image ---
            $extra_image_name = '';
            if (!empty($_FILES['extra_image']['name'])) {
                $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
                $extra_config['upload_path']   = $upload_folder;
                $extra_config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $extra_config['max_size']      = 2048;
                $extra_config['file_name']     = $extra_file_name;

                $this->upload->initialize($extra_config);
                if ($this->upload->do_upload('extra_image')) {
                    $extraUploadData = $this->upload->data();
                    $extra_image_name = $extraUploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button-placement');
                    return;
                }
            }

            // Prepare update data
            $updateData = array(
                'style_id'             => $style_id,
                'fabric_id'            => $fabric_id,
                'button_placement_name' => $button_placement_name,
            );

            if (!empty($image_name)) {
                $updateData['image'] = $design_no . '/front/' . $image_name;
            }

            if (!empty($extra_image_name)) {
                $updateData['extra_image'] = $design_no . '/front/' . $extra_image_name;
            }

            // Update DB record
            $this->AdminModel->updateButtonPlacements($id, $updateData);

            $this->session->set_flashdata('success', 'Button Placement updated successfully!');
            redirect('admin/button-placement');
        } else {
            redirect('admin');
        }
    }


    //Breast Placement

    public function breastPocket()
    {
        // Check if user is logged in (optional)
        if ($this->session->userdata('id')) {

            // Get all lapels from model
            $breastPocket = $this->AdminModel->getAllBreastPocket();
            //  print_r($buttonPlacement);die();
            // Pass data to view
            $data['content'] = array(
                'breastPocket' => $breastPocket,
            );

            $data['SEO'] = array('pageTitle' => 'Breast Pocket');
            $data['page'] = 'breast-pocket';

            // Load the main admin template with embedded page
            $this->load->view('admin/template', $data);
        } else {
            // Redirect to login if session expired
            redirect(base_url('admin'));
        }
    }


    public function addBreastPocket()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabricName();
            // $data['fabricName'] = $this->AdminModel->getAllFabricName();


            //  print_r $data['fabricName'];die();


            $data['SEO'] = array('pageTitle' => 'Add Breast Pocket');
            $data['page'] = 'add-breast-pocket';
            // $data['style'] = $selected_fabric;  // instead of only ['fabric_id' => $fabric_id]
            $data['content'] = array();

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function saveBreastPocket()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $fabric_id = $post['fabric_id'];
            $style_id = $post['style_id'];
            $breast_pocket_name = $post['breast_pocket_name'];

            $this->load->model('AdminModel');

            // Get design_no from fabric
            $fabric = $this->db->select('design_no')
                ->from('tb_fabric')
                ->where('fabric_id', $fabric_id)
                ->get()
                ->row();

            if (!$fabric) {
                $this->session->set_flashdata('error', 'Invalid fabric selected.');
                redirect('admin/breast-pocket');
                return;
            }

            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/front/';

            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $this->load->library('upload');

            // --- Handle main image ---
            $image_name = '';
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->upload->initialize($config);
                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/breast-pocket');
                    return;
                }
            }

            // --- Handle extra image ---
            $extra_image_name = '';
            if (!empty($_FILES['extra_image']['name'])) {
                $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
                $extra_config['upload_path']   = $upload_folder;
                $extra_config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $extra_config['max_size']      = 2048;
                $extra_config['file_name']     = $extra_file_name;

                $this->upload->initialize($extra_config);
                if ($this->upload->do_upload('extra_image')) {
                    $extraUploadData = $this->upload->data();
                    $extra_image_name = $extraUploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/breast-pocket');
                    return;
                }
            }

            // ✅ Insert into DB
            $BreastPocketData = array(
                'fabric_id'           => $fabric_id,
                'style_id'            => $style_id,
                'breast_pocket_name'  => $breast_pocket_name,
                'image'               => !empty($image_name) ? $design_no . '/front/' . $image_name : '',
                'extra_image'         => !empty($extra_image_name) ? $design_no . '/front/' . $extra_image_name : '',
                'created_at'          => date('Y-m-d H:i:s')
            );

            $this->AdminModel->insertBreastPocket($BreastPocketData);

            $this->session->set_flashdata('success', 'Breast Pocket added successfully!');
            redirect('admin/breast-pocket');
        } else {
            redirect('admin');
        }
    }


    public function breastPocketStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('lapel_id');
            $result = $this->AdminModel->breastPocketStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'breast pocket status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'breast pocket placement status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change breast pocket status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function editBreastPocket($id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabric();
            $UpdateBreastPocket = $this->AdminModel->UpdateBreastPocket($id);

            //  print_r($this->db->last_query());die();
            //   print_r($UpdateButtonHole);die();

            $data['SEO'] = array('pageTitle' => 'Update Breast Pocket');
            $data['page'] = 'edit-breast-pocket';
            $data['content'] = array(
                'UpdateBreastPocket' => $UpdateBreastPocket
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function updateBreastPocket()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $id = $post['id'];
            $style_id = $post['style_id'];
            $fabric_id = $post['fabric_id'];
            $breast_pocket_name = $post['breast_pocket_name'];

            // Get fabric design_no
            $fabric = $this->db->select('design_no')
                ->from('tb_fabric')
                ->where('fabric_id', $fabric_id)
                ->get()
                ->row();

            if (!$fabric) {
                $this->session->set_flashdata('error', 'Invalid fabric selected.');
                redirect('admin/breast-pocket');
                return;
            }

            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/front/';
            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $this->load->library('upload');

            // Handle main image upload
            $image_name = '';
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->upload->initialize($config);
                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/breast-pocket');
                    return;
                }
            }

            // Handle extra image upload
            $extra_image_name = '';
            if (!empty($_FILES['extra_image']['name'])) {
                $extra_file_name = preg_replace('/\s+/', '-', strtolower($_FILES['extra_image']['name']));
                $extra_config['upload_path']   = $upload_folder;
                $extra_config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $extra_config['max_size']      = 2048;
                $extra_config['file_name']     = $extra_file_name;

                $this->upload->initialize($extra_config);
                if ($this->upload->do_upload('extra_image')) {
                    $extraUploadData = $this->upload->data();
                    $extra_image_name = $extraUploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/breast-pocket');
                    return;
                }
            }

            // Prepare update data
            $updateData = array(
                'style_id'           => $style_id,
                'fabric_id'          => $fabric_id,
                'breast_pocket_name' => $breast_pocket_name,
            );

            if (!empty($image_name)) {
                $updateData['image'] = $design_no . '/front/' . $image_name;
            }

            if (!empty($extra_image_name)) {
                $updateData['extra_image'] = $design_no . '/front/' . $extra_image_name;
            }

            // Update in DB
            $this->AdminModel->updateBreastPockets($id, $updateData);

            $this->session->set_flashdata('success', 'Breast pocket updated successfully!');
            redirect('admin/breast-pocket');
        } else {
            redirect('admin');
        }
    }



    //sleeve
    public function sleeve($fabric_id = "")
    {
        // Get fabric_id from POST if available, otherwise keep URL parameter
        $fabric_id_post = $this->input->post('fabric_id');
        if (!empty($fabric_id_post)) {
            $fabric_id = $fabric_id_post;
        }

        // Check if admin is logged in
        if (!empty($this->session->userdata('id'))) {

            // Get styles filtered by fabric_id
            $sleeves = $this->AdminModel->getAllFabricAgainstSleeve($fabric_id);
            $data['content'] = array(
                'sleeves' => $sleeves,
                'fabric_id' => $fabric_id
            );



            $data['SEO'] = array('pageTitle' => 'Sleeves');
            $data['page'] = 'sleeves';

            // Load the admin template view
            $this->load->view('admin/template', $data);
        } else {
            // Redirect to login or base admin page
            redirect(base_url('admin'));
        }
    }



    public function addSleeve($fabric_id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabricName();

            //  print_r $data['fabricName'];die();


            $data['SEO'] = array('pageTitle' => 'Add Sleeves');
            $data['page'] = 'add-sleeves';
            $data['sleeves'] = $selected_fabric;  // instead of only ['fabric_id' => $fabric_id]
            $data['content'] = array();

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }



    public function saveSleeve()
    {


        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $fabric_id = $post['fabric_id'];
            $sleeves_title = $post['sleeves_title'];

            // Load model
            $this->load->model('AdminModel');

            // ✅ Get design_no from tb_fabric using fabric_id
            $this->db->select('design_no');
            $this->db->from('tb_fabric');
            $this->db->where('fabric_id', $fabric_id);
            $query = $this->db->get();
            $fabric = $query->row();

            // if (!$fabric || empty($fabric->design_no)) {
            //     $this->session->set_flashdata('error', 'Invalid fabric selected.');
            //     redirect('admin/style');
            //     return;
            // }

            // ✅ Create upload folder
            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/front/';

            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            // ✅ Handle file upload
            $image_name = '';
            if (!empty($_FILES['sleeves_image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['sleeves_image']['name']));

                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('sleeves_image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/sleeve');
                    return;
                }
            }

            // ✅ Insert into tb_style
            $sleeveData = array(
                'fabric_id'   => $fabric_id,
                'sleeves_title' => $sleeves_title,
                'sleeves_image' => $design_no . '/front/' . $image_name,
                'created_at'  => date('Y-m-d H:i:s')
            );

            //   print_r($sleeveData);die();

            $this->AdminModel->insertSleeve($sleeveData);
            // print_r($this->db->last_query());die();

            $this->session->set_flashdata('success', 'Sleeve added successfully!');
            redirect('admin/sleeve');
        } else {
            redirect('admin');
        }
    }


    public function sleeveStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('id');
            $result = $this->AdminModel->sleeveStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'sleeve status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'sleeve status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change sleeve status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function editSleeve($id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabric();
            $UpdateSleeve = $this->AdminModel->UpdateSleeve($id);

            //  print_r($this->db->last_query());die();
            //  print_r($UpdateSleeve);die();

            $data['SEO'] = array('pageTitle' => 'Update Sleeve');
            $data['page'] = 'edit-sleeves';
            $data['content'] = array(
                'UpdateSleeve' => $UpdateSleeve
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function updateSleeve()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $id = $post['id'];
            $fabric_id = $post['fabric_id'];
            $sleeves_title = $post['sleeves_title'];

            // Get design_no from tb_fabric using fabric_id
            $this->db->select('design_no');
            $this->db->from('tb_fabric');
            $this->db->where('fabric_id', $fabric_id);
            $query = $this->db->get();
            $fabric = $query->row();

            if (!$fabric) {
                $this->session->set_flashdata('error', 'Invalid fabric selected.');
                redirect('admin/style');
                return;
            }

            // Set upload folder
            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/front/';

            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            // Handle image upload
            $image_name = '';
            if (!empty($_FILES['sleeves_image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['sleeves_image']['name']));

                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('sleeves_image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/sleeve');
                    return;
                }
            }

            // Prepare update data
            $updateData = array(
                'id' => $id,
                'fabric_id' => $fabric_id,
                'sleeves_title' => $sleeves_title,
                'created_at' => date('Y-m-d H:i:s')
            );

            // print_r($updateData);die();

            if (!empty($image_name)) {
                $updateData['sleeves_image'] = $design_no . '/front/' . $image_name;
            }

            // Update style record
            $this->AdminModel->updateSleeveFabricWise($id, $updateData);

            // print_r($this->db->last_query());die();

            $this->session->set_flashdata('success', 'Sleeve updated successfully!');
            redirect('admin/sleeve');
        } else {
            redirect('admin');
        }
    }


    //Button Master
    public function button()
    {
        if (!empty($this->session->userdata('id'))) {
            $this->load->model('AdminModel'); // Make sure model is loaded
            $data['button'] = $this->AdminModel->getAllButtons(); // Load all buttons

            //  print_r($data['styleName']);die();

            $data['SEO'] = array('pageTitle' => 'Buttons');
            $data['page'] = 'button'; // This should match the view name: views/admin/button.php

            $this->load->view('admin/template', $data); // Load template and pass all data
        } else {
            redirect(base_url('admin')); // redirect to login
        }
    }


    public function addButton()
    {
        if (!empty($this->session->userdata('id'))) {

            $data['styleName'] = $this->AdminModel->getAllStyleName();
            // print_r($data['styleName']);die();
            $data['SEO'] = array('pageTitle' => 'Add Button');
            $data['page'] = 'add-button';
            $data['content'] = array();
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function saveButton()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $button_color = $post['button_color'];
            $style_title = $post['style_title'];
            // Upload directory
            $upload_folder = './uploads/buttons/';
            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            // Handle image upload
            $image_name = '';
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048; // 2MB
                $config['file_name']     = $file_name;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button');
                    return;
                }
            }

            $display_image = '';
            if (!empty($_FILES['display_image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_POST['style_title'])) . '+' . preg_replace('/\s+/', '-', strtolower($_POST['button_color']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048; // 2MB
                $config['file_name']     = $file_name;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('display_image')) {
                    $uploadData = $this->upload->data();
                    $display_image = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button');
                    return;
                }
            }


            // Prepare data for DB
            $buttonData = array(
                'style_title'  => $style_title,
                'button_color' => $button_color,
                'image' => $image_name,
                'display_image' => $display_image,
                'created_at'   => date('Y-m-d H:i:s')
            );

            // print_r($buttonData);
            // die();

            // Save data to DB
            $this->load->model('AdminModel');
            $this->AdminModel->insertButton($buttonData); // Add this function in your AdminModel

            // print_r($this->db->last_query());die();


            $this->session->set_flashdata('success', 'Button saved successfully!');
            redirect('admin/button');
        } else {
            redirect('admin');
        }
    }

    public function buttonStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('id');
            $result = $this->AdminModel->buttonStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'button status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'button status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change button status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function editButton($id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['styleName'] = $this->AdminModel->getAllStyleName();
            $UpdateButton = $this->AdminModel->UpdateButton($id);

            //  print_r($this->db->last_query());die();
            //  print_r($UpdateFabric);die();

            $data['SEO'] = array('pageTitle' => 'Update Button');
            $data['page'] = 'edit-button';
            $data['content'] = array(
                'UpdateButton' => $UpdateButton
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function updateButton()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $id = $post['id'];
            $button_color = $post['button_color'];
            $style_title = $post['style_title'];

            $upload_folder = './uploads/buttons/';
            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $image_name = '';

            // Handle file upload
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button');
                    return;
                }
            }

            $display_image = '';

            // Handle file upload
            if (!empty($_FILES['display_image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_POST['style_title'])) . '+' . preg_replace('/\s+/', '-', strtolower($_POST['button_color']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $display_image = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/button');
                    return;
                }
            }


            $updateData = array(
                'button_color' => $button_color,
                'style_title' => $style_title,
            );

            // print_r($updateData);
            // die();

            if (!empty($image_name) && !empty($display_image)) {
                $updateData['image'] = $image_name;
                $updateData['display_image'] = $display_image;
            }
            // print_r($updateData['image']);
            // die();

            // Update DB
            $this->AdminModel->updateButtons($id, $updateData);

            // print_r($this->db->last_query());die();

            $this->session->set_flashdata('success', 'Button updated successfully!');
            redirect('admin/button');
        } else {
            redirect('admin');
        }
    }


    //Elbow Master Master
    public function elbowPatches()
    {
        if (!empty($this->session->userdata('id'))) {
            $this->load->model('AdminModel'); // Make sure model is loaded
            $data['elbowPatches'] = $this->AdminModel->getAllElbowPatches(); // Load all buttons

            // print_r($data['elbowPatches']);die();

            $data['SEO'] = array('pageTitle' => 'Elbow Patches');
            $data['page'] = 'elbow_patches'; // This should match the view name: views/admin/button.php

            $this->load->view('admin/template', $data); // Load template and pass all data
        } else {
            redirect(base_url('admin')); // redirect to login
        }
    }


    public function addElbowPatches()
    {
        if (!empty($this->session->userdata('id'))) {

            $data['SEO'] = array('pageTitle' => 'Add Elbow Patches');
            $data['page'] = 'add-elbow-patches';
            $data['content'] = array();
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function saveElbowPatches()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $name  = $post['image_name'];

            // Upload directory
            $upload_folder = './uploads/elbow_patches/';
            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            // Handle image upload
            $image_name = '';
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048; // 2MB
                $config['file_name']     = $file_name;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image_name = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/elbow-patches');
                    return;
                }
            }

            // Prepare data for DB
            $elbowPatchesData = array(
                'image_name'  => $name,
                'image' => 'elbow_patches/' . $image_name,
                'created_at'   => date('Y-m-d H:i:s')
            );

            // print_r($elbowPatchesData);die();

            // Save data to DB
            $this->load->model('AdminModel');
            $this->AdminModel->insertElbowPatches($elbowPatchesData); // Add this function in your AdminModel

            //  print_r($this->db->last_query());die();


            $this->session->set_flashdata('success', 'Elbow Patches saved successfully!');
            redirect('admin/elbow-patches');
        } else {
            redirect('admin');
        }
    }

    public function elbowPatchesStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('id');
            $result = $this->AdminModel->elbowPatchesStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'elbow patches status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'elbow patches status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change elbow patches status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function editElbowPatches($id = "")
    {
        if (!empty($this->session->userdata('id'))) {

            $UpdateElbowPatches = $this->AdminModel->UpdateElbowPatches($id);

            //  print_r($this->db->last_query());die();
            //  print_r($UpdateFabric);die();

            $data['SEO'] = array('pageTitle' => 'Update Elbow Patches');
            $data['page'] = 'edit-elbow-patches';
            $data['content'] = array(
                'UpdateElbowPatches' => $UpdateElbowPatches
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function updateElbowPatches()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $id = $post['id'];
            $image_name = $post['image_name'];


            $upload_folder = './uploads/elbow_patches/';
            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $image = '';

            // Handle file upload
            if (!empty($_FILES['image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['image']['name']));
                $config['upload_path']   = $upload_folder;
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 2048;
                $config['file_name']     = $file_name;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('image')) {
                    $uploadData = $this->upload->data();
                    $image = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/elbow-patches');
                    return;
                }
            }

            $updateData = array(
                'image_name' => $image_name,

            );

            // print_r($updateData);die();

            if (!empty($image)) {
                $updateData['image'] = 'elbow_patches/' . $image;
            }
            // print_r($updateData['image']);die();

            // Update DB
            $this->AdminModel->updateElbowPatchess($id, $updateData);

            // print_r($this->db->last_query());die();

            $this->session->set_flashdata('success', 'elbow patches updated successfully!');
            redirect('admin/elbow-patches');
        } else {
            redirect('admin');
        }
    }



    //Folded Pant
    public function foldedPant($fabric_id = "")
    {
        // Get fabric_id from POST if available, otherwise keep URL parameter
        $fabric_id_post = $this->input->post('fabric_id');
        if (!empty($fabric_id_post)) {
            $fabric_id = $fabric_id_post;
        }

        // Check if admin is logged in
        if (!empty($this->session->userdata('id'))) {

            // Get styles filtered by fabric_id
            $foldedPant = $this->AdminModel->getAllFoldedPatches($fabric_id);
            $data['content'] = array(
                'foldedPant' => $foldedPant,
                'fabric_id' => $fabric_id
            );

            $data['SEO'] = array('pageTitle' => 'Folded Pant');
            $data['page'] = 'folded-pant';

            // Load the admin template view
            $this->load->view('admin/template', $data);
        } else {
            // Redirect to login or base admin page
            redirect(base_url('admin'));
        }
    }



    public function addFoldedPant($fabric_id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabricName();

            //  print_r $data['fabricName'];die();


            $data['SEO'] = array('pageTitle' => 'Add Folded Pant');
            $data['page'] = 'add-folded-pant';
            $data['style'] = $selected_fabric;  // instead of only ['fabric_id' => $fabric_id]
            $data['content'] = array();

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }


    public function saveFoldedPant()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $fabric_id = $post['fabric_id'];
            $type = $post['type'];
            $this->load->model('AdminModel');

            // ✅ Get design_no from fabric
            $fabric = $this->db->select('design_no')
                ->from('tb_fabric')
                ->where('fabric_id', $fabric_id)
                ->get()
                ->row();

            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/pant/';

            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $this->load->library('upload');

            // ✅ Upload folded_pant_image
            $folded_pant_image = '';
            if (!empty($_FILES['folded_pant_image']['name'])) {
                $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['folded_pant_image']['name']));
                $config = [
                    'upload_path'   => $upload_folder,
                    'allowed_types' => 'jpg|jpeg|png|gif|webp',
                    'max_size'      => 2048,
                    'file_name'     => $type . '+folded_pant',
                ];

                $this->upload->initialize($config);
                if ($this->upload->do_upload('folded_pant_image')) {
                    $uploadData = $this->upload->data();
                    $folded_pant_image = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/folded-pant');
                    return;
                }
            }

            // ✅ Upload button_image
            $button_image = '';
            if (!empty($_FILES['button_image']['name'])) {
                $file_name_extra = preg_replace('/\s+/', '-', strtolower($_FILES['button_image']['name']));
                $config_extra = [
                    'upload_path'   => $upload_folder,
                    'allowed_types' => 'jpg|jpeg|png|gif|webp',
                    'max_size'      => 2048,
                    'file_name'     => $type . '+button',
                ];

                $this->upload->initialize($config_extra);
                if ($this->upload->do_upload('button_image')) {
                    $uploadData = $this->upload->data();
                    $button_image =  $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/folded-pant');
                    return;
                }
            }

            // ✅ Upload pocket_image
            $pocket_image = '';
            if (!empty($_FILES['pocket_image']['name'])) {
                $file_name_pocket = preg_replace('/\s+/', '-', strtolower($_FILES['pocket_image']['name']));
                $config_pocket = [
                    'upload_path'   => $upload_folder,
                    'allowed_types' => 'jpg|jpeg|png|gif|webp',
                    'max_size'      => 2048,
                    'file_name'     => $type . '+pocket',
                ];

                $this->upload->initialize($config_pocket);
                if ($this->upload->do_upload('pocket_image')) {
                    $uploadData = $this->upload->data();
                    $pocket_image = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/folded-pant');
                    return;
                }
            }

            // ✅ Save to DB
            $foldedPantData = array(
                'fabric_id'          => $fabric_id,
                'type'               => $type,
                'folded_pant_image'  => $folded_pant_image,
                'button_image'       => $button_image,
                'pocket_image'       => $pocket_image,
                'created_at'         => date('Y-m-d H:i:s')
            );

            // print_r($foldedPantData);die();
            $this->AdminModel->insertFoldedPant($foldedPantData);

            // print_r($foldedPantData);die();
            $this->session->set_flashdata('success', 'Folded pant added successfully!');
            redirect('admin/folded-pant');
        } else {
            redirect('admin');
        }
    }

    public function foldedPantStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('folded_pant_id');
            $result = $this->AdminModel->foldedPantStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'folded pant status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'folded pant status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change folded pant status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function editFoldedPant($id = "")
    {
        if (!empty($this->session->userdata('id'))) {
            $data['fabricName'] = $this->AdminModel->getAllFabric();
            $UpdateFoldedPant = $this->AdminModel->UpdateFoldedPant($id);

            //  print_r($this->db->last_query());die();
            // print_r($UpdateFoldedPant);die();

            $data['SEO'] = array('pageTitle' => 'Update Folded Pant');
            $data['page'] = 'edit-folded-pant';
            $data['content'] = array(
                'UpdateFoldedPant' => $UpdateFoldedPant
            );
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function updateFoldedPant()
    {
        if (!empty($this->session->userdata('id'))) {
            $post = $this->input->post();
            $this->load->model('AdminModel');

            $fabric_id        = $post['fabric_id'];
            $type             = $post['type'];
            $folded_pant_id   = isset($post['folded_pant_id']) ? $post['folded_pant_id'] : null;

            // Get design_no
            $fabric = $this->db->select('design_no')
                ->from('tb_fabric')
                ->where('fabric_id', $fabric_id)
                ->get()
                ->row();

            $design_no = strtolower(str_replace(' ', '-', $fabric->design_no));
            $upload_folder = './uploads/fabric/' . $design_no . '/pant/';

            if (!is_dir($upload_folder)) {
                mkdir($upload_folder, 0777, true);
            }

            $this->load->library('upload');

            // Fetch old data if updating
            $existing = [];
            if ($folded_pant_id) {
                $existing = $this->db->get_where('tb_folded_pants', ['folded_pant_id' => $folded_pant_id])->row_array();
            }

            // Upload folded_pant_image
            $folded_pant_image = $existing['folded_pant_image'] ?? '';
            if (!empty($_FILES['folded_pant_image']['name'])) {
                $config = [
                    'upload_path'   => $upload_folder,
                    'allowed_types' => 'jpg|jpeg|png|gif|webp',
                    'max_size'      => 2048,
                    'file_name'     => $type . '+folded_pant',
                ];
                $this->upload->initialize($config);
                if ($this->upload->do_upload('folded_pant_image')) {
                    $uploadData = $this->upload->data();
                    $folded_pant_image = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/folded-pant');
                    return;
                }
            }

            // Upload button_image
            $button_image = $existing['button_image'] ?? '';
            if (!empty($_FILES['button_image']['name'])) {
                $config = [
                    'upload_path'   => $upload_folder,
                    'allowed_types' => 'jpg|jpeg|png|gif|webp',
                    'max_size'      => 2048,
                    'file_name'     => $type . '+button',
                ];
                $this->upload->initialize($config);
                if ($this->upload->do_upload('button_image')) {
                    $uploadData = $this->upload->data();
                    $button_image = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/folded-pant');
                    return;
                }
            }

            // Upload pocket_image
            $pocket_image = $existing['pocket_image'] ?? '';
            if (!empty($_FILES['pocket_image']['name'])) {
                $config = [
                    'upload_path'   => $upload_folder,
                    'allowed_types' => 'jpg|jpeg|png|gif|webp',
                    'max_size'      => 2048,
                    'file_name'     => $type . '+pocket',
                ];
                $this->upload->initialize($config);
                if ($this->upload->do_upload('pocket_image')) {
                    $uploadData = $this->upload->data();
                    $pocket_image = $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('admin/folded-pant');
                    return;
                }
            }

            // Final data array
            $foldedPantData = array(
                'fabric_id'         => $fabric_id,
                'type'              => $type,
                'folded_pant_image' => $folded_pant_image,
                'button_image'      => $button_image,
                'pocket_image'      => $pocket_image,
            );

            if ($folded_pant_id) {
                $this->AdminModel->updateFoldedPants($folded_pant_id, $foldedPantData);
                $this->session->set_flashdata('success', 'Folded pant updated successfully!');
            } else {
                $foldedPantData['created_at'] = date('Y-m-d H:i:s');
                $this->AdminModel->insertFoldedPant($foldedPantData);
                $this->session->set_flashdata('success', 'Folded pant added successfully!');
            }

            redirect('admin/folded-pant');
        } else {
            redirect('admin');
        }
    }

    public function lapelColor()
    {
        if (!empty($this->session->userdata('id'))) {

            $allLapelColors = $this->AdminModel->getAllLapelColors();

            $data['SEO'] = array('pageTitle' => 'Lapel Colors');
            $data['page'] = 'lapel-colors';
            $data['content'] = array(
                'allLapelColors' => $allLapelColors,
            );

            $this->load->view('admin/template', $data);
        } else {
            redirect('admin');
        }
    }

    public function addLapelColor()
    {
        $masterStyles = $this->AdminModel->getAllStyleName();
        $masterJacketLapels = $this->AdminModel->getAllJacketLapelsByName();
        $masterLapelWidths = $this->AdminModel->getAllLapelWidthsByName();
        $masterColors =  $this->AdminModel->getAllColorsByName();

        $data['SEO'] = array('pageTitle' => 'Add Lapel Colors');
        $data['page'] = 'add-lapel-colors';
        $data['content'] = array(
            'masterStyles' => $masterStyles,
            'masterJacketLapels' => $masterJacketLapels,
            'masterLapelWidths' => $masterLapelWidths,
            'masterColors' => $masterColors,
        );

        $this->load->view('admin/template', $data);
    }

    public function saveLapelColor()
    {
        $lapel_id = $this->input->post('lapel_id');

        $style_title = strtolower(str_replace(' ', '-', $this->input->post('style_title')));
        $jacket_lapels_title = strtolower(str_replace(' ', '-', $this->input->post('jacket_lapels_title')));
        $lapel_width_title = strtolower(str_replace(' ', '-', $this->input->post('lapel_width_title')));

        $color = $this->input->post('color_thread');
        $color_without_hash = ltrim($color, '#');

        $upload_folder = './uploads/thread-colors/';

        if (!is_dir($upload_folder)) {
            mkdir($upload_folder, 0777, true);
        }

        $this->load->library('upload');

        // ✅ Upload folded_pant_image
        $folded_pant_image = '';
        if (!empty($_FILES['display_image']['name'])) {
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['display_image']['name']));
            $config = [
                'upload_path'   => $upload_folder,
                'allowed_types' => 'jpg|jpeg|png|gif|webp',
                'max_size'      => 2048,
                'file_name'     => $style_title . '+' . $jacket_lapels_title . '+' . $lapel_width_title . '+' . $color_without_hash,
            ];

            $this->upload->initialize($config);
            if ($this->upload->do_upload('display_image')) {
                $uploadData = $this->upload->data();
                $folded_pant_image = $uploadData['file_name'];
            } else {
                $this->session->set_flashdata('error', $this->upload->display_errors());
                redirect('admin/lapel-color');
                return;
            }
        }

        $button_image = '';
        if (!empty($_FILES['button_image']['name'])) {
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['button_image']['name']));
            $config = [
                'upload_path'   => $upload_folder,
                'allowed_types' => 'jpg|jpeg|png|gif|webp',
                'max_size'      => 2048,
                'file_name'     => $style_title . '+' . $jacket_lapels_title . '+' . $lapel_width_title . '+' . $color_without_hash . '+button',
            ];

            $this->upload->initialize($config);
            if ($this->upload->do_upload('button_image')) {
                $uploadData = $this->upload->data();
                $button_image = $uploadData['file_name'];
            } else {
                $this->session->set_flashdata('error', $this->upload->display_errors());
                redirect('admin/lapel-color');
                return;
            }
        }

        $button_thread = '';
        if (!empty($_FILES['button_thread']['name'])) {
            $file_name = preg_replace('/\s+/', '-', strtolower($_FILES['button_thread']['name']));
            $config = [
                'upload_path'   => $upload_folder,
                'allowed_types' => 'jpg|jpeg|png|gif|webp',
                'max_size'      => 2048,
                'file_name'     => $style_title . '+' . $jacket_lapels_title . '+' . $lapel_width_title . '+' . $color_without_hash . '+button_thread',
            ];

            $this->upload->initialize($config);
            if ($this->upload->do_upload('button_thread')) {
                $uploadData = $this->upload->data();
                $button_thread = $uploadData['file_name'];
            } else {
                $this->session->set_flashdata('error', $this->upload->display_errors());
                redirect('admin/lapel-color');
                return;
            }
        }

        $data = array(
            'style' => $style_title,
            'lapel' => $jacket_lapels_title,
            'lapel_width' => $lapel_width_title,
            'color' => $color_without_hash,
            'display_image' => $folded_pant_image,
            'button_image' => $button_image,
            'button_thread' => $button_thread,
        );

        if ($lapel_id) {
            if ($button_image == '') {
                unset($data['button_image']);
            }
            if ($display_image == '') {
                unset($data['display_image']);
            }
            if ($button_thread == '') {
                unset($data['button_thread']);
            }
            $this->AdminModel->saveLapelColor($data, $lapel_id);
            $this->session->set_flashdata('success', 'Record updated successfully!');
        } else {
            $this->AdminModel->saveLapelColor($data);
            $this->session->set_flashdata('success', 'Record added successfully!');
        }

        redirect('admin/lapel-color');
    }

    public function editLapelColor($id)
    {
        if (!empty($this->session->userdata('id'))) {
            $masterStyles = $this->AdminModel->getAllStyleName();
            $masterJacketLapels = $this->AdminModel->getAllJacketLapelsByName();
            $masterLapelWidths = $this->AdminModel->getAllLapelWidthsByName();
            $masterColors =  $this->AdminModel->getAllColorsByName();

            $lapelData = $this->AdminModel->editLapelColor($id);

            $data['SEO'] = array('pageTitle' => 'Add Lapel Colors');
            $data['page'] = 'add-lapel-colors';
            $data['content'] = array(
                'flag' => 'edit',
                'masterStyles' => $masterStyles,
                'masterJacketLapels' => $masterJacketLapels,
                'masterLapelWidths' => $masterLapelWidths,
                'masterColors' => $masterColors,
                'lapelData' => $lapelData,
            );

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function lapelColorStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('id');
            $result = $this->AdminModel->lapelColorStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'Status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'Status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change Status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function linings()
    {
        if (!empty($this->session->userdata('id'))) {

            $allLinings = $this->AdminModel->getAllLinings();

            $data['SEO'] = array('pageTitle' => 'Linings');
            $data['page'] = 'linings';
            $data['content'] = array(
                'allLinings' => $allLinings,
            );

            $this->load->view('admin/template', $data);
        } else {
            redirect('admin');
        }
    }

    public function liningStatusUpdate()
    {
        if (!empty($this->session->userdata('id'))) {
            $id = $this->input->post('id');
            $result = $this->AdminModel->liningStatusUpdate($id);
            if ($result) {
                $this->session->set_flashdata('success', 'Status changed successfully');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'success', 'message' => 'Status changed successfully.');
            } else {
                $this->session->set_flashdata('success', 'Unable to change Status');
                // redirect(base_url('admin/interview-companies/'));
                $response = array('status' => 'error', 'message' => 'Failed to update status.');
            }
            echo json_encode($response);
        } else {
            redirect(base_url('admin'));
        }
    }

    public function addLining()
    {
        $data['SEO'] = array('pageTitle' => 'Add Lining');
        $data['page'] = 'add-lining';
        $data['content'] = array();

        $this->load->view('admin/template', $data);
    }

public function saveLining()
{
    $lining_id = $this->input->post('lining_id');

    $type = strtolower(str_replace(' ', '-', $this->input->post('type')));
    $display_type = trim($this->input->post('type'));
    $fabric_name = strtolower(str_replace(' ', '-', $this->input->post('fabric_name')));
    $display_fabric_name = trim($this->input->post('fabric_name'));
    $blend = trim($this->input->post('blend'));

    // ✅ S3 base path
    $base_path = "lining/";

    // ✅ fabric_image upload
    $fabric_image = '';
    if (!empty($_FILES['fabric_image']['name'])) {
        $file_name = $type . '+fabric.' . pathinfo($_FILES['fabric_image']['name'], PATHINFO_EXTENSION);
        $image_key = S3_TYPE . "/{$base_path}{$file_name}";

        try {
            $this->s3->putObject([
                'Bucket'      => $this->S3_BUCKET,
                'Key'         => $image_key,
                'SourceFile'  => $_FILES['fabric_image']['tmp_name'], // ✅ FIXED
                'ACL'         => 'public-read',
                'ContentType' => mime_content_type($_FILES['fabric_image']['tmp_name']) // ✅ FIXED
            ]);

            $fabric_image = "{$base_path}{$file_name}";
        } catch (Aws\Exception\AwsException $e) {
            $this->session->set_flashdata('error', 'Fabric image upload failed: ' . $e->getMessage());
            redirect('admin/linings');
            return;
        }
    }

    // ✅ top_image upload
    $top_image = '';
    if (!empty($_FILES['top_image']['name'])) {
        $file_name = $type . '+top.' . pathinfo($_FILES['top_image']['name'], PATHINFO_EXTENSION);
        $image_key = S3_TYPE . "/{$base_path}{$file_name}";

        try {
            $this->s3->putObject([
                'Bucket'      => $this->S3_BUCKET,
                'Key'         => $image_key,
                'SourceFile'  => $_FILES['top_image']['tmp_name'], // ✅ FIXED
                'ACL'         => 'public-read',
                'ContentType' => mime_content_type($_FILES['top_image']['tmp_name']) // ✅ FIXED
            ]);

            $top_image = "{$base_path}{$file_name}";
        } catch (Aws\Exception\AwsException $e) {
            $this->session->set_flashdata('error', 'Top image upload failed: ' . $e->getMessage());
            redirect('admin/linings');
            return;
        }
    }

    // ✅ bottom_image upload
    $bottom_image = '';
    if (!empty($_FILES['bottom_image']['name'])) {
        $file_name = $type . '+bottom.' . pathinfo($_FILES['bottom_image']['name'], PATHINFO_EXTENSION);
        $image_key = S3_TYPE . "/{$base_path}{$file_name}";

        try {
            $this->s3->putObject([
                'Bucket'      => $this->S3_BUCKET,
                'Key'         => $image_key,
                'SourceFile'  => $_FILES['bottom_image']['tmp_name'], // ✅ FIXED
                'ACL'         => 'public-read',
                'ContentType' => mime_content_type($_FILES['bottom_image']['tmp_name']) // ✅ FIXED
            ]);

            $bottom_image = "{$base_path}{$file_name}";
        } catch (Aws\Exception\AwsException $e) {
            $this->session->set_flashdata('error', 'Bottom image upload failed: ' . $e->getMessage());
            redirect('admin/linings');
            return;
        }
    }

    // ✅ Prepare DB data
    $data = array(
        'type'         => $display_type,
        'fabric_name'  => $display_fabric_name,
        'blend'        => $blend,
        'fabric_image' => $fabric_image,
        'top_image'    => $top_image,
        'bottom_image' => $bottom_image,
    );

    if ($lining_id) {
        if ($fabric_image == '') unset($data['fabric_image']);
        if ($top_image == '') unset($data['top_image']);
        if ($bottom_image == '') unset($data['bottom_image']);

        $this->AdminModel->saveLining($data, $lining_id);
        $this->session->set_flashdata('success', 'Record updated successfully!');
    } else {
        $this->AdminModel->saveLining($data);
        $this->session->set_flashdata('success', 'Record added successfully!');
    }

    redirect('admin/linings');
}



    public function editLining($id)
    {
        $liningData = $this->AdminModel->editLining($id);
        $data['SEO'] = array('pageTitle' => 'Edit Lining');
        $data['page'] = 'add-lining';
        $data['content'] = array(
            'flag' => 'edit',
            'liningData' => $liningData,
        );

        $this->load->view('admin/template', $data);
    }


    //order Master
    public function order()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['order'] = $this->AdminModel->getAllOrders();
            //  print_r($data['order']);die();
            $data['content'] = array();
            $data['SEO'] = array('pageTitle' => 'Pending Orders');
            $data['page'] = 'order';
            // print_r($data);die();
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin/order'));
        }
    }

    public function pendingOrderStatusUpdate()
    {
        if (!$this->session->userdata('id')) {
            redirect(base_url('admin'));
            return;
        }

        $id     = $this->input->post('id');
        $status = $this->input->post('status');

        if (!$id || !$status) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid request.']);
            return;
        }

        $result = $this->AdminModel->updateOrderStatus($id, $status);

        if ($result) {
            echo json_encode(['status' => 'success', 'message' => 'Order status updated successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update status.']);
        }
    }

    //Dispatched Order 
    public function dispatchedOrder()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['dispatchedOrder'] = $this->AdminModel->getAllDispatchedOrders();
            // print_r($data['dispatchedOrder']);die();
            $data['content'] = array();
            $data['SEO'] = array('pageTitle' => 'Dispatched Orders');
            $data['page'] = 'dispatched_order';
            // print_r($data);die();
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin/order'));
        }
    }

    public function displatchedOrderStatusUpdate()
    {
        if (!$this->session->userdata('id')) {
            redirect(base_url('admin'));
            return;
        }

        $id     = $this->input->post('id');
        $status = $this->input->post('status');

        if (!$id || !$status) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid request.']);
            return;
        }

        $result = $this->AdminModel->DiapatchedOrderStatusUpdate($id, $status);

        if ($result) {
            echo json_encode(['status' => 'success', 'message' => 'Order status updated successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update status.']);
        }
    }


    //Completed Order 
    public function completedOrder()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['completedOrder'] = $this->AdminModel->getAllCompletdOrders();
            // print_r($data['completedOrder']);die();
            $data['content'] = array();
            $data['SEO'] = array('pageTitle' => 'Completed Orders');
            $data['page'] = 'completed_order';
            // print_r($data);die();
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin/order'));
        }
    }

    //Completed Order 
    public function cancelledOrder()
    {
        if (!empty($this->session->userdata('id'))) {
            $data['cancelledOrder'] = $this->AdminModel->getAllCancelledOrders();
            // print_r($data['completedOrder']);die();
            $data['content'] = array();
            $data['SEO'] = array('pageTitle' => 'Cancelled Orders');
            $data['page'] = 'cancelled_order';
            // print_r($data);die();
            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin/order'));
        }
    }

    public function paymentStatusUpdate()
    {
        if (!$this->session->userdata('id')) {
            redirect(base_url('admin'));
            return;
        }

        $id     = $this->input->post('id');
        $status = $this->input->post('status');
        $type   = $this->input->post('type'); // optional: 'payment' or 'order'

        if (!$id || !$status) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid request.']);
            return;
        }

        if ($type == 'payment') {
            // Call model function to update payment status
            $result = $this->AdminModel->updatePaymentStatus($id, $status);

            if ($result) {
                echo json_encode(['status' => 'success', 'message' => 'Status updated successfully.']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Failed to update status.']);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid type.']);
        }
    }


    //Order Details
    // Order Details
    public function orderDetails($order_id = "")
    {
        if ($this->session->userdata('id')) {

            $orderDetails = $this->AdminModel->getAllOrderDetails($order_id);

            //  print_r($orderDetails);die();

            if (!$orderDetails) {
                // If no order found, redirect back or show error
                $this->session->set_flashdata('error', 'Order not found.');
                redirect(base_url('admin/order'));
                return;
            }

            $data['content'] = array(
                'orderDetails' => $orderDetails
            );

            $data['SEO']   = array('pageTitle' => 'Order Details');
            $data['page']  = 'order-detail';

            $this->load->view('admin/template', $data);
        } else {
            redirect(base_url('admin/order'));
        }
    }
}
